/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.pokersource.enumerate.BeliefVector;
import org.pokersource.enumerate.Enumerate;
import org.pokersource.enumerate.HandMatchup;
import org.pokersource.enumerate.HoldemBeliefVector;
import org.pokersource.enumerate.MatchupOutcome;
import org.pokersource.enumerate.RankOrdering;
import org.pokersource.game.Deck;
import org.pokersource.util.NestedLoopEnumeration;
import org.pokersource.util.NestedLoopSampling;

public class SAIE {
    private SAIE() {
    }

    private static void accumulateOrderings(Map map, int[][] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray2[i];
            RankOrdering rankOrdering = new RankOrdering(nArray[i]);
            Integer n2 = (Integer)map.get(rankOrdering);
            if (n2 != null) {
                n += n2.intValue();
            }
            map.put(rankOrdering, new Integer(n));
        }
    }

    public static void FlopGameSAIE(int n, int n2, int n3, BeliefVector[] beliefVectorArray, long l, long l2, double[] dArray, Map map, Map map2) {
        if (map != null) {
            map.clear();
        }
        if (map2 != null) {
            map2.clear();
        }
        int n4 = beliefVectorArray.length;
        long[][] lArrayArray = new long[n4][];
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            lArrayArray[i] = beliefVectorArray[i].getHands();
            nArray[i] = lArrayArray[i].length;
            dArray[i] = 0.0;
        }
        long l3 = l2 | l;
        double d = 0.0;
        double[] dArray2 = new double[n4];
        long[] lArray = new long[n4];
        Enumeration enumeration = n2 == 0 ? new NestedLoopEnumeration(nArray) : new NestedLoopSampling(nArray);
        int n5 = 0;
        block1: while (enumeration.hasMoreElements() && (n2 == 0 || n5 < n2)) {
            Object object;
            int n6;
            int[] nArray2 = (int[])enumeration.nextElement();
            long l4 = l3;
            double d2 = 1.0;
            for (n6 = 0; n6 < n4; ++n6) {
                lArray[n6] = lArrayArray[n6][nArray2[n6]];
                if ((lArray[n6] & l4) != 0L) continue block1;
                l4 |= lArray[n6];
                if ((d2 *= beliefVectorArray[n6].getBeliefProb(lArray[n6])) == 0.0) continue block1;
            }
            if (map2 == null) {
                Enumerate.PotEquity(n, n3, lArray, l, l2, dArray2);
            } else {
                int[][][] nArrayArray = new int[1][][];
                object = new int[1][];
                Enumerate.PotEquity(n, n3, lArray, l, l2, dArray2, nArrayArray, object);
                SAIE.accumulateOrderings(map2, nArrayArray[0], object[0]);
            }
            if (map != null) {
                HandMatchup handMatchup = new HandMatchup(lArray);
                object = new MatchupOutcome(d2, dArray2);
                MatchupOutcome matchupOutcome = (MatchupOutcome)map.get(handMatchup);
                if (matchupOutcome != null) {
                    matchupOutcome.merge((MatchupOutcome)object);
                } else {
                    map.put(handMatchup, object);
                }
            }
            for (n6 = 0; n6 < n4; ++n6) {
                int n7 = n6;
                dArray[n7] = dArray[n7] + dArray2[n6] * d2;
            }
            d += d2;
            ++n5;
        }
        if (n5 == 0 || d == 0.0) {
            throw new IllegalArgumentException("no matchups sampled");
        }
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n8++;
            dArray[n9] = dArray[n9] / d;
        }
        if (map != null) {
            for (MatchupOutcome matchupOutcome : map.values()) {
                matchupOutcome.matchProb /= d;
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = stringArray.length - 4;
        System.out.println("nplayers=" + n3 + ", nmatchups=" + n + (n == 0 ? " (enumerate)" : " (sample)") + ", noutcomes=" + n2 + (n2 == 0 ? " (enumerate)" : " (sample)"));
        BeliefVector[] beliefVectorArray = new HoldemBeliefVector[n3];
        for (int i = 0; i < n3; ++i) {
            beliefVectorArray[i] = new HoldemBeliefVector(stringArray[i + 2]);
            System.out.println("beliefs[" + i + "].toString = " + beliefVectorArray[i].toString());
            System.out.println("beliefs[" + i + "].toStringAtomic = " + beliefVectorArray[i].toStringAtomic());
        }
        long l = Deck.parseCardMask(stringArray[stringArray.length - 2]);
        long l2 = Deck.parseCardMask(stringArray[stringArray.length - 1]);
        System.out.println("board = " + Deck.cardMaskString(l));
        System.out.println("dead = " + Deck.cardMaskString(l2));
        double[] dArray = new double[n3];
        TreeMap treeMap = new TreeMap();
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM8, n, n2, beliefVectorArray, l, l2, dArray, null, treeMap);
        for (int i = 0; i < n3; ++i) {
            System.out.println("FlopGameSAIE: totalev[" + i + "] = " + dArray[i]);
        }
        System.out.println("FlopGameSAIE: relative rank ordering histogram:");
        for (RankOrdering rankOrdering : treeMap.keySet()) {
            Integer n4 = (Integer)treeMap.get(rankOrdering);
            System.out.println("\t" + rankOrdering + " " + n4);
        }
    }
}

