/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.HashSet;
import org.pokersource.enumerate.BaseHandGroup;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.game.Deck;

public class HoldemUniversalGroup
extends BaseHandGroup
implements HoldemHandGroup {
    public HoldemUniversalGroup(String string) {
        if (!string.equals("<any>")) {
            throw new IllegalArgumentException("unable to parse spec: " + string);
        }
        this.myspec = string;
        this.myhands = new HashSet();
        for (int i = 0; i < Deck.RANK_COUNT; ++i) {
            for (int j = i; j < Deck.RANK_COUNT; ++j) {
                for (int k = 0; k < Deck.SUIT_COUNT; ++k) {
                    for (int i2 = 0; i2 < Deck.SUIT_COUNT; ++i2) {
                        if (i == j && k >= i2) continue;
                        this.addAtomic(i, k, j, i2);
                    }
                }
            }
        }
    }

    private void addAtomic(int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            throw new IllegalArgumentException("atomic cards are identical");
        }
        long l = Deck.createCardMask(n, n2);
        long l2 = Deck.createCardMask(n3, n4);
        long l3 = l | l2;
        this.myhands.add(new Long(l3));
    }

    public static void main(String[] stringArray) {
        String string = "<any>";
        HoldemUniversalGroup holdemUniversalGroup = new HoldemUniversalGroup(string);
        System.out.println("spec=" + string + ", parsed=" + holdemUniversalGroup.toString() + ", atomic=" + holdemUniversalGroup.toStringAtomic());
    }
}

