/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.enumerate.HandValuation;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;

public class HoldemHandOrdering
extends HandValuation {
    private static final int TOTAL_HANDS = 1326;

    public HoldemHandOrdering(String string) throws IOException {
        super(string);
    }

    public HoldemHandOrdering(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public void fromStream(InputStream inputStream) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            while (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).startsWith("#")) {
                HoldemHandGroup holdemHandGroup;
                try {
                    holdemHandGroup = HoldemHandGroupFactory.getInstance(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException("unable to parse group: " + string2);
                }
                double d = (double)n / 1326.0;
                this.setValue(holdemHandGroup, d);
                n += holdemHandGroup.numHands();
            }
        }
        if (n != 1326) {
            throw new RuntimeException("missing hands in input");
        }
    }

    @Override
    public void fromFile(String string) throws IOException {
        this.fromStream(new FileInputStream(string));
    }

    public static void main(String[] stringArray) {
        HoldemHandOrdering holdemHandOrdering;
        String string = stringArray[0];
        String string2 = stringArray[1];
        double d = Double.parseDouble(string2);
        try {
            holdemHandOrdering = new HoldemHandOrdering(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        System.out.println("HandValuation = [" + holdemHandOrdering + "]");
        System.out.println("hv[>=" + string2 + "] = ");
        HandGroup[] handGroupArray = holdemHandOrdering.greaterEqual(d);
        for (int i = 0; i < handGroupArray.length; ++i) {
            System.out.print(handGroupArray[i] + " ");
        }
        System.out.println();
    }
}

