/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.pokersource.enumerate.HoldemAbdulGroup;
import org.pokersource.enumerate.HoldemAtomicGroup;
import org.pokersource.enumerate.HoldemCanonGroup;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemSMGroup;
import org.pokersource.enumerate.HoldemThresholdGroup;
import org.pokersource.enumerate.HoldemUniversalGroup;

public class HoldemHandGroupFactory {
    private static Class[] groupClasses = new Class[]{HoldemAtomicGroup.class, HoldemCanonGroup.class, HoldemSMGroup.class, HoldemAbdulGroup.class, HoldemUniversalGroup.class, HoldemThresholdGroup.class};
    private static HashMap cache = new HashMap();

    private HoldemHandGroupFactory() {
    }

    private static HoldemHandGroup tryGetInstance(Class clazz, String string) {
        HoldemHandGroup holdemHandGroup = null;
        try {
            Constructor constructor = clazz.getConstructor(String.class);
            holdemHandGroup = (HoldemHandGroup)constructor.newInstance(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!(throwable instanceof IllegalArgumentException)) {
                throw new RuntimeException("BUG1: " + throwable);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("BUG2: " + exception);
        }
        return holdemHandGroup;
    }

    public static HoldemHandGroup getInstance(String string, Class clazz) {
        HoldemHandGroup holdemHandGroup = (HoldemHandGroup)cache.get(string);
        if (holdemHandGroup != null) {
            return holdemHandGroup;
        }
        holdemHandGroup = HoldemHandGroupFactory.tryGetInstance(clazz, string);
        if (holdemHandGroup == null) {
            throw new IllegalArgumentException("cannot parse spec: " + string);
        }
        cache.put(string, holdemHandGroup);
        return holdemHandGroup;
    }

    public static HoldemHandGroup getInstance(String string) {
        HoldemHandGroup holdemHandGroup = (HoldemHandGroup)cache.get(string);
        if (holdemHandGroup != null) {
            return holdemHandGroup;
        }
        for (int i = 0; i < groupClasses.length && holdemHandGroup == null; ++i) {
            holdemHandGroup = HoldemHandGroupFactory.tryGetInstance(groupClasses[i], string);
        }
        if (holdemHandGroup == null) {
            throw new IllegalArgumentException("cannot parse spec: " + string);
        }
        cache.put(string, holdemHandGroup);
        return holdemHandGroup;
    }
}

