/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.pokersource.enumerate.BaseHandGroup;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;
import org.pokersource.game.Deck;

public class HoldemCanonGroup
extends BaseHandGroup
implements HoldemHandGroup {
    private static Perl5Compiler compiler = new Perl5Compiler();
    private static Perl5Matcher matcher = new Perl5Matcher();
    private static Pattern pairPattern;
    private static Pattern suitedPattern;
    private static Pattern offsuitPattern;

    public HoldemCanonGroup(String string) {
        this.myspec = string;
        this.myhands = new HashSet();
        if (matcher.matches(string, pairPattern)) {
            MatchResult matchResult = matcher.getMatch();
            int n = Deck.parseRank(matchResult.group(1));
            this.addPair(n);
        } else if (matcher.matches(string, suitedPattern)) {
            MatchResult matchResult = matcher.getMatch();
            int n = Deck.parseRank(matchResult.group(1));
            int n2 = Deck.parseRank(matchResult.group(2));
            this.addSuited(n, n2);
        } else if (matcher.matches(string, offsuitPattern)) {
            MatchResult matchResult = matcher.getMatch();
            int n = Deck.parseRank(matchResult.group(1));
            int n3 = Deck.parseRank(matchResult.group(2));
            this.addOffsuit(n, n3);
        } else {
            throw new IllegalArgumentException("unable to parse groupSpec: " + string);
        }
    }

    private void addPair(int n) {
        for (int i = 0; i < Deck.SUIT_COUNT; ++i) {
            long l = Deck.createCardMask(n, i);
            for (int j = i + 1; j < Deck.SUIT_COUNT; ++j) {
                long l2 = Deck.createCardMask(n, j);
                long l3 = l | l2;
                this.myhands.add(new Long(l3));
            }
        }
    }

    private void addSuited(int n, int n2) {
        for (int i = 0; i < Deck.SUIT_COUNT; ++i) {
            long l = Deck.createCardMask(n, i);
            long l2 = Deck.createCardMask(n2, i);
            long l3 = l | l2;
            this.myhands.add(new Long(l3));
        }
    }

    private void addOffsuit(int n, int n2) {
        for (int i = 0; i < Deck.SUIT_COUNT; ++i) {
            long l = Deck.createCardMask(n, i);
            for (int j = 0; j < Deck.SUIT_COUNT; ++j) {
                if (i == j) continue;
                long l2 = Deck.createCardMask(n2, j);
                long l3 = l | l2;
                this.myhands.add(new Long(l3));
            }
        }
    }

    public static Iterator allGroups() {
        String[] stringArray = new String[]{"A", "K", "Q", "J", "T", "9", "8", "7", "6", "5", "4", "3", "2"};
        ArrayList<HoldemCanonGroup> arrayList = new ArrayList<HoldemCanonGroup>(169);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = i; j < stringArray.length; ++j) {
                String string = stringArray[i] + stringArray[j];
                HoldemCanonGroup holdemCanonGroup = (HoldemCanonGroup)HoldemHandGroupFactory.getInstance(string, HoldemCanonGroup.class);
                arrayList.add(holdemCanonGroup);
                if (i == j) continue;
                string = string + "s";
                holdemCanonGroup = (HoldemCanonGroup)HoldemHandGroupFactory.getInstance(string, HoldemCanonGroup.class);
                arrayList.add(holdemCanonGroup);
            }
        }
        return arrayList.iterator();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        HoldemCanonGroup holdemCanonGroup = new HoldemCanonGroup(string);
        System.out.println("spec=" + string + ", parsed=" + holdemCanonGroup.toString() + ", atomic=" + holdemCanonGroup.toStringAtomic());
    }

    static {
        try {
            pairPattern = compiler.compile("^([AKQJT98765432])(\\1)$");
            suitedPattern = compiler.compile("^([AKQJT98765432])([AKQJT98765432])s$");
            offsuitPattern = compiler.compile("^([AKQJT98765432])([AKQJT98765432])$");
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException("BUG: " + malformedPatternException.toString());
        }
    }
}

