/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.HashSet;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.pokersource.enumerate.BaseHandGroup;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.game.Deck;

public class HoldemAtomicGroup
extends BaseHandGroup
implements HoldemHandGroup {
    private static Perl5Compiler compiler = new Perl5Compiler();
    private static Perl5Matcher matcher = new Perl5Matcher();
    private static Pattern atomicPattern;

    public HoldemAtomicGroup(String string) {
        this.myspec = string;
        this.myhands = new HashSet();
        if (!matcher.matches(string, atomicPattern)) {
            throw new IllegalArgumentException("unable to parse groupSpec: " + string);
        }
        MatchResult matchResult = matcher.getMatch();
        int n = Deck.parseRank(matchResult.group(1));
        int n2 = Deck.parseSuit(matchResult.group(2));
        int n3 = Deck.parseRank(matchResult.group(3));
        int n4 = Deck.parseSuit(matchResult.group(4));
        this.addAtomic(n, n2, n3, n4);
    }

    private void addAtomic(int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            throw new IllegalArgumentException("atomic cards are identical");
        }
        long l = Deck.createCardMask(n, n2);
        long l2 = Deck.createCardMask(n3, n4);
        long l3 = l | l2;
        this.myhands.add(new Long(l3));
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        HoldemAtomicGroup holdemAtomicGroup = new HoldemAtomicGroup(string);
        System.out.println("spec=" + string + ", parsed=" + holdemAtomicGroup.toString() + ", atomic=" + holdemAtomicGroup.toStringAtomic());
    }

    static {
        try {
            atomicPattern = compiler.compile("^([AKQJT98765432])([shdc])([AKQJT98765432])([shdc])$");
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException("BUG: " + malformedPatternException.toString());
        }
    }
}

