/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.HashSet;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.pokersource.enumerate.BaseHandGroup;
import org.pokersource.enumerate.HoldemCanonGroup;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;
import org.pokersource.game.Deck;

public class HoldemAbdulGroup
extends BaseHandGroup
implements HoldemHandGroup {
    private static Perl5Compiler compiler = new Perl5Compiler();
    private static Perl5Matcher matcher = new Perl5Matcher();
    private static Pattern pairPattern;
    private static Pattern acePattern;
    private static Pattern kingPattern;
    private static Pattern queenPattern;
    private static Pattern rankPattern;
    private static Pattern gap0Pattern;
    private static Pattern gap1Pattern;
    private static Pattern gap2Pattern;

    public HoldemAbdulGroup(String string) {
        this.myspec = string;
        this.myhands = new HashSet();
        if (matcher.matches(string, pairPattern)) {
            int n;
            MatchResult matchResult = matcher.getMatch();
            for (int i = n = Deck.parseRank(matchResult.group(1)); i <= Deck.RANK_ACE; ++i) {
                String string2 = Deck.rankString(i);
                String string3 = string2 + string2;
                HoldemCanonGroup holdemCanonGroup = (HoldemCanonGroup)HoldemHandGroupFactory.getInstance(string3, HoldemCanonGroup.class);
                this.myhands.addAll(holdemCanonGroup.myhands);
            }
        } else if (matcher.matches(string, acePattern) || matcher.matches(string, kingPattern) || matcher.matches(string, queenPattern) || matcher.matches(string, rankPattern)) {
            int n;
            MatchResult matchResult = matcher.getMatch();
            String string4 = matchResult.group(1);
            String string5 = matchResult.group(2);
            String string6 = matchResult.group(3);
            if (string5.equals("x")) {
                string5 = "2";
            }
            int n2 = Deck.parseRank(string4);
            for (int i = n = Deck.parseRank(string5); i < n2; ++i) {
                string5 = Deck.rankString(i);
                String string7 = string4 + string5 + string6;
                HoldemCanonGroup holdemCanonGroup = (HoldemCanonGroup)HoldemHandGroupFactory.getInstance(string7, HoldemCanonGroup.class);
                this.myhands.addAll(holdemCanonGroup.myhands);
            }
        } else if (matcher.matches(string, gap0Pattern) || matcher.matches(string, gap1Pattern) || matcher.matches(string, gap2Pattern)) {
            MatchResult matchResult = matcher.getMatch();
            String string8 = matchResult.group(1).substring(0, 1);
            String string9 = matchResult.group(1).substring(1, 2);
            String string10 = matchResult.group(2);
            int n = Deck.parseRank(string8);
            int n3 = Deck.parseRank(string9);
            int n4 = n - n3;
            for (int i = n; i <= Deck.RANK_JACK; ++i) {
                int n5 = i - n4;
                string8 = Deck.rankString(i);
                string9 = Deck.rankString(n5);
                String string11 = string8 + string9 + string10;
                HoldemCanonGroup holdemCanonGroup = (HoldemCanonGroup)HoldemHandGroupFactory.getInstance(string11, HoldemCanonGroup.class);
                this.myhands.addAll(holdemCanonGroup.myhands);
            }
        } else {
            throw new IllegalArgumentException("unable to parse groupSpec: " + string);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        HoldemAbdulGroup holdemAbdulGroup = new HoldemAbdulGroup(string);
        System.out.println("spec=" + string + ", parsed=" + holdemAbdulGroup.toString() + ", atomic=" + holdemAbdulGroup.toStringAtomic());
    }

    static {
        try {
            pairPattern = compiler.compile("^([AKQJT98765432])(\\1)\\+$");
            acePattern = compiler.compile("^(A)([KQJT98765432])(s?)\\+$");
            kingPattern = compiler.compile("^(K)([QJT98765432])(s?)\\+$");
            queenPattern = compiler.compile("^(Q)([JT98765432])(s?)\\+$");
            rankPattern = compiler.compile("^([AKQJT9876543])(x)(s?)\\+$");
            gap0Pattern = compiler.compile("^(JT|T9|98|87|76|65|54|43|32)(s?)\\+$");
            gap1Pattern = compiler.compile("^(J9|T8|97|86|75|64|53|42)(s?)\\+$");
            gap2Pattern = compiler.compile("^(J8|T7|96|85|74|63|52)(s?)\\+$");
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException("BUG: " + malformedPatternException.toString());
        }
    }
}

