/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;
import org.pokersource.util.ValueSortedMap;

public class HandValuation {
    private ValueSortedMap values = new ValueSortedMap();

    public HandValuation() {
    }

    public HandValuation(String string) throws IOException {
        this();
        this.fromFile(string);
    }

    public HandValuation(InputStream inputStream) throws IOException {
        this();
        this.fromStream(inputStream);
    }

    public void fromFile(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void fromStream(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setValue(HandGroup handGroup, double d) {
        this.values.put(handGroup, new Double(d));
    }

    public double getValue(HandGroup handGroup) {
        Double d = (Double)this.values.get(handGroup);
        return d;
    }

    public HandGroup[] less(double d) {
        List list = this.values.less(new Double(d));
        return list.toArray(new HandGroup[list.size()]);
    }

    public HandGroup[] lessEqual(double d) {
        List list = this.values.less(new Double(d + 1.0E-10));
        return list.toArray(new HandGroup[list.size()]);
    }

    public HandGroup[] greater(double d) {
        List list = this.values.greaterEqual(new Double(d + 1.0E-10));
        return list.toArray(new HandGroup[list.size()]);
    }

    public HandGroup[] greaterEqual(double d) {
        List list = this.values.greaterEqual(new Double(d));
        return list.toArray(new HandGroup[list.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (HandGroup handGroup : this.values.keyList()) {
            Double d = (Double)this.values.get(handGroup);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(handGroup + ":" + d);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        int n;
        HandValuation handValuation = new HandValuation();
        HoldemHandGroup holdemHandGroup = HoldemHandGroupFactory.getInstance("AKs");
        handValuation.setValue(holdemHandGroup, 80.0);
        HoldemHandGroup holdemHandGroup2 = HoldemHandGroupFactory.getInstance("AQ");
        handValuation.setValue(holdemHandGroup2, 70.0);
        HoldemHandGroup holdemHandGroup3 = HoldemHandGroupFactory.getInstance("T8");
        handValuation.setValue(holdemHandGroup3, 30.0);
        HoldemHandGroup holdemHandGroup4 = HoldemHandGroupFactory.getInstance("32s");
        handValuation.setValue(holdemHandGroup4, 10.0);
        System.out.println("HandValuation = [" + handValuation + "]");
        HandGroup[] handGroupArray = handValuation.less(30.0);
        System.out.print("Groups scoring <  30: ");
        for (n = 0; n < handGroupArray.length; ++n) {
            System.out.print(handGroupArray[n] + " ");
        }
        System.out.println();
        handGroupArray = handValuation.lessEqual(30.0);
        System.out.print("Groups scoring <= 30: ");
        for (n = 0; n < handGroupArray.length; ++n) {
            System.out.print(handGroupArray[n] + " ");
        }
        System.out.println();
        handGroupArray = handValuation.greater(30.0);
        System.out.print("Groups scoring >  30: ");
        for (n = 0; n < handGroupArray.length; ++n) {
            System.out.print(handGroupArray[n] + " ");
        }
        System.out.println();
        handGroupArray = handValuation.greaterEqual(30.0);
        System.out.print("Groups scoring >= 30: ");
        for (n = 0; n < handGroupArray.length; ++n) {
            System.out.print(handGroupArray[n] + " ");
        }
        System.out.println();
    }
}

