/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.pokersource.enumerate.BaseHandGroup;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.game.Deck;

public abstract class BeliefVector {
    private String myspec;
    HandGroup universalGroup;
    private HashMap groupProb;
    private long deadCards;
    private HashMap uncondHandProb;
    private HashMap condHandProb;
    private boolean hasRelative = false;
    private boolean hasAbsolute = false;

    public BeliefVector(String string) {
        this.myspec = string;
        this.groupProb = new HashMap();
        this.deadCards = 0L;
        this.uncondHandProb = null;
        this.condHandProb = null;
    }

    public abstract void fromString(String var1);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (HandGroup handGroup : this.groupProb.keySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(((Object)handGroup).toString());
            double d = (Double)this.groupProb.get(handGroup);
            String string = d < 0.0 ? "=" : ":";
            int n = (int)Math.round(100.0 * Math.abs(d));
            stringBuffer.append(string + n);
        }
        if (this.deadCards != 0L) {
            stringBuffer.append(" / " + Deck.cardMaskString(this.deadCards));
        }
        return stringBuffer.toString();
    }

    public String toStringAtomic() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Long l : this.condHandProb.keySet()) {
            long l2 = l;
            double d = (Double)this.condHandProb.get(l);
            if (stringBuffer.length() > 1) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Deck.cardMaskString(l2, ""));
            int n = (int)Math.round(10000.0 * Math.abs(d));
            stringBuffer.append(":" + n);
        }
        return stringBuffer.toString();
    }

    public int numHands() {
        return this.condHandProb.size();
    }

    public long[] getHands() {
        long[] lArray = new long[this.condHandProb.size()];
        int n = 0;
        Iterator iterator = this.condHandProb.keySet().iterator();
        while (iterator.hasNext()) {
            lArray[n++] = (Long)iterator.next();
        }
        return lArray;
    }

    public double getBeliefProb(long l) {
        Double d = (Double)this.condHandProb.get(new Long(l));
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private void computeConditionedHandProb() {
        if (this.deadCards == 0L) {
            this.condHandProb = this.uncondHandProb;
            return;
        }
        double d = 0.0;
        for (Long l : this.uncondHandProb.keySet()) {
            long l2 = l;
            Double d2 = (Double)this.uncondHandProb.get(l);
            double d3 = d2;
            if ((l2 & this.deadCards) == 0L) continue;
            d += d3;
        }
        this.condHandProb = new HashMap();
        if (d > 0.999999) {
            throw new IllegalArgumentException("dead cards exclude all hands");
        }
        double d4 = 1.0 / (1.0 - d);
        for (Long l : this.uncondHandProb.keySet()) {
            long l3 = l;
            if ((l3 & this.deadCards) != 0L) continue;
            Double d5 = (Double)this.uncondHandProb.get(l);
            double d6 = d5;
            double d7 = d6 * d4;
            this.condHandProb.put(l, new Double(d7));
        }
    }

    private double totalRelativeProb() {
        double d = 0.0;
        for (HandGroup handGroup : this.groupProb.keySet()) {
            double d2 = (Double)this.groupProb.get(handGroup);
            int n = handGroup.numHands();
            if (!(d2 > 0.0)) continue;
            d += d2 * (double)n;
        }
        return d;
    }

    private double totalAbsoluteProb() {
        double d = 0.0;
        for (HandGroup handGroup : this.groupProb.keySet()) {
            double d2 = (Double)this.groupProb.get(handGroup);
            if (!(d2 < 0.0)) continue;
            d += -d2;
        }
        return d;
    }

    private void computeUnconditionedHandProb() {
        this.uncondHandProb = new HashMap();
        double d = this.totalRelativeProb();
        for (HandGroup handGroup : this.groupProb.keySet()) {
            long[] lArray = handGroup.getHands();
            double d2 = (Double)this.groupProb.get(handGroup);
            double d3 = d2 < 0.0 ? -d2 / (double)lArray.length : (d2 > 0.0 ? d2 / d : 0.0);
            if (!(d3 > 0.0)) continue;
            for (int i = 0; i < lArray.length; ++i) {
                Long l = new Long(lArray[i]);
                Double d4 = new Double(d3);
                if (this.uncondHandProb.containsKey(l)) {
                    throw new IllegalArgumentException("duplicate hand: " + Deck.cardMaskString(lArray[i]));
                }
                this.uncondHandProb.put(l, d4);
            }
        }
    }

    public void setDeadCards(long l) {
        this.deadCards = l;
        this.computeConditionedHandProb();
    }

    private void addHandGroup(HandGroup handGroup, double d) {
        this.groupProb.put(handGroup, new Double(d));
        this.computeUnconditionedHandProb();
        this.computeConditionedHandProb();
    }

    void addHandGroupRelative(HandGroup handGroup, double d) {
        if (this.hasAbsolute) {
            throw new IllegalArgumentException("cannot mix relative and absolute probs");
        }
        this.addHandGroup(handGroup, d);
        this.hasRelative = true;
    }

    void addHandGroupAbsolute(HandGroup handGroup, double d) {
        if (this.hasRelative) {
            throw new IllegalArgumentException("cannot mix relative and absolute probs");
        }
        this.addHandGroup(handGroup, -d);
        this.hasAbsolute = true;
    }

    private void addRemaining(double d) {
        BaseHandGroup baseHandGroup = new BaseHandGroup();
        baseHandGroup.myspec = "<other>";
        baseHandGroup.myhands = new HashSet();
        baseHandGroup.myhands.addAll(this.universalGroup.getHandSet());
        for (HandGroup handGroup : this.groupProb.keySet()) {
            baseHandGroup.myhands.removeAll(handGroup.getHandSet());
        }
        this.groupProb.put(baseHandGroup, new Double(d));
        this.computeUnconditionedHandProb();
        this.computeConditionedHandProb();
    }

    void addRemainingRelative(double d) {
        if (this.hasAbsolute) {
            throw new IllegalArgumentException("cannot mix relative and absolute probs");
        }
        this.addRemaining(d);
        this.hasRelative = true;
    }

    void addRemainingAbsolute(double d) {
        if (this.hasRelative) {
            throw new IllegalArgumentException("cannot mix relative and absolute probs");
        }
        this.addRemaining(-d);
        this.hasAbsolute = true;
    }

    void validate() {
        if (this.hasAbsolute && this.totalAbsoluteProb() != 1.0) {
            throw new IllegalArgumentException("absolute probabilities must sum to 1");
        }
        if (this.hasRelative && this.totalRelativeProb() <= 0.0) {
            throw new IllegalArgumentException("relative probabilities must be positive");
        }
    }
}

