/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.game.Deck;

public class BaseHandGroup
implements HandGroup,
Comparable {
    String myspec;
    HashSet myhands;

    @Override
    public String getGroupSpec() {
        return this.myspec;
    }

    @Override
    public int numHands() {
        return this.myhands.size();
    }

    @Override
    public long[] getHands() {
        long[] lArray = new long[this.myhands.size()];
        int n = 0;
        Iterator iterator = this.myhands.iterator();
        while (iterator.hasNext()) {
            lArray[n++] = (Long)iterator.next();
        }
        return lArray;
    }

    @Override
    public Set getHandSet() {
        return this.myhands;
    }

    @Override
    public boolean isHandInGroup(long l) {
        return this.myhands.contains(new Long(l));
    }

    @Override
    public String toString() {
        return this.myspec;
    }

    @Override
    public String toStringAtomic() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.myhands.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            if (stringBuffer.length() > 1) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Deck.cardMaskString(l, ""));
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        BaseHandGroup baseHandGroup = (BaseHandGroup)object;
        return this.myspec.compareTo(baseHandGroup.myspec);
    }
}

