/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.javabean;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;

public class BeanProvider {
    protected static final Object[] NO_PARAMS = new Object[0];
    private final Comparator propertyNameComparator;
    private final transient Map propertyNameCache = new WeakHashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public BeanProvider() {
        this(null);
    }

    public BeanProvider(Comparator propertyNameComparator) {
        this.propertyNameComparator = propertyNameComparator;
    }

    public Object newInstance(Class type) {
        try {
            return this.getDefaultConstrutor(type).newInstance(NO_PARAMS);
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new ObjectAccessException("Constructor for " + type.getName() + " threw an exception", e);
        }
    }

    public void visitSerializableProperties(Object object, Visitor visitor) {
        PropertyDescriptor[] propertyDescriptors = this.getSerializableProperties(object);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor property = propertyDescriptors[i];
            try {
                Method readMethod = property.getReadMethod();
                String name = property.getName();
                Class<?> definedIn = readMethod.getDeclaringClass();
                if (!visitor.shouldVisit(name, definedIn)) continue;
                Object value = readMethod.invoke(object, new Object[0]);
                visitor.visit(name, property.getPropertyType(), definedIn, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + "." + property.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + "." + property.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not get property " + object.getClass() + "." + property.getName(), e);
            }
        }
    }

    public void writeProperty(Object object, String propertyName, Object value) {
        PropertyDescriptor property = this.getProperty(propertyName, object.getClass());
        try {
            property.getWriteMethod().invoke(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + "." + property.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + "." + property.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectAccessException("Could not set property " + object.getClass() + "." + property.getName(), e);
        }
    }

    public Class getPropertyType(Object object, String name) {
        return this.getProperty(name, object.getClass()).getPropertyType();
    }

    public boolean propertyDefinedInClass(String name, Class type) {
        return this.getProperty(name, type) != null;
    }

    public boolean canInstantiate(Class type) {
        return this.getDefaultConstrutor(type) != null;
    }

    protected Constructor getDefaultConstrutor(Class type) {
        Constructor<?>[] constructors = type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (c.getParameterTypes().length != 0 || !Modifier.isPublic(c.getModifiers())) continue;
            return c;
        }
        return null;
    }

    private PropertyDescriptor[] getSerializableProperties(Object object) {
        Map nameMap = this.getNameMap(object.getClass());
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>(nameMap.size());
        Set names = nameMap.keySet();
        if (this.propertyNameComparator != null) {
            TreeSet sortedSet = new TreeSet(this.propertyNameComparator);
            sortedSet.addAll(names);
            names = sortedSet;
        }
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)nameMap.get(iter.next());
            if (!this.canStreamProperty(descriptor)) continue;
            result.add(descriptor);
        }
        return result.toArray(new PropertyDescriptor[result.size()]);
    }

    protected boolean canStreamProperty(PropertyDescriptor descriptor) {
        return descriptor.getReadMethod() != null && descriptor.getWriteMethod() != null;
    }

    public boolean propertyWriteable(String name, Class type) {
        PropertyDescriptor property = this.getProperty(name, type);
        return property.getWriteMethod() != null;
    }

    private PropertyDescriptor getProperty(String name, Class type) {
        return (PropertyDescriptor)this.getNameMap(type).get(name);
    }

    private Map getNameMap(Class type) {
        Map nameMap = (Map)this.propertyNameCache.get(type);
        if (nameMap == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(type, class$java$lang$Object == null ? (class$java$lang$Object = BeanProvider.class$("java.lang.Object")) : class$java$lang$Object);
            }
            catch (IntrospectionException e) {
                throw new ObjectAccessException("Cannot get BeanInfo of type " + type.getName(), e);
            }
            nameMap = new OrderRetainingMap();
            this.propertyNameCache.put(type, nameMap);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                nameMap.put(descriptor.getName(), descriptor);
            }
        }
        return nameMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface Visitor {
        public boolean shouldVisit(String var1, Class var2);

        public void visit(String var1, Class var2, Class var3, Object var4);
    }
}

