/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.bpmn2.core.Definitions;
import org.drools.bpmn2.core.Interface;
import org.drools.bpmn2.core.ItemDefinition;
import org.drools.bpmn2.core.Lane;
import org.drools.bpmn2.core.Message;
import org.drools.bpmn2.core.SequenceFlow;
import org.drools.bpmn2.legacy.beta1.XmlBPMNProcessDumper;
import org.drools.compiler.xml.ProcessBuildData;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.process.core.Context;
import org.drools.process.core.context.exception.ActionExceptionHandler;
import org.drools.process.core.context.exception.ExceptionHandler;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.process.core.context.swimlane.Swimlane;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.process.core.timer.Timer;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.impl.ConstraintImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.impl.NodeImpl;
import org.drools.workflow.core.node.CompositeContextNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StateNode;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHandler
extends BaseAbstractHandler
implements Handler {
    public static final String CONNECTIONS = "BPMN.Connections";

    public ProcessHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(Interface.class);
            this.validPeers.add(Message.class);
            this.validPeers.add(ItemDefinition.class);
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String packageName = attrs.getValue("http://www.jboss.org/drools", "packageName");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(id);
        if (name == null) {
            name = id;
        }
        process.setName(name);
        process.setType("RuleFlow");
        if (packageName == null) {
            packageName = "org.drools.bpmn2";
        }
        process.setPackageName(packageName);
        ((ProcessBuildData)parser.getData()).setProcess((Process)process);
        return process;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        RuleFlowProcess process = (RuleFlowProcess)parser.getCurrent();
        List connections = (List)process.getMetaData(CONNECTIONS);
        ProcessHandler.linkConnections((NodeContainer)process, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)process);
        List lanes = (List)process.getMetaData("BPMN.Lanes");
        this.assignLanes(process, lanes);
        this.postProcessNodes((NodeContainer)process);
        return process;
    }

    public Class<?> generateNodeFor() {
        return Process.class;
    }

    public static void linkConnections(NodeContainer nodeContainer, List<SequenceFlow> connections) {
        if (connections != null) {
            for (SequenceFlow connection : connections) {
                Node target;
                Node source;
                block16: {
                    String targetRef;
                    block15: {
                        String sourceRef = connection.getSourceRef();
                        targetRef = connection.getTargetRef();
                        source = null;
                        target = null;
                        try {
                            sourceRef = sourceRef.substring(1);
                            sourceRef = sourceRef.substring(sourceRef.lastIndexOf("-") + 1);
                            source = nodeContainer.getNode((long)new Integer(sourceRef).intValue());
                        }
                        catch (NumberFormatException e) {
                            for (Node node : nodeContainer.getNodes()) {
                                if (!connection.getSourceRef().equals(node.getMetaData("UniqueId"))) continue;
                                source = node;
                                break;
                            }
                            if (source != null) break block15;
                            throw new IllegalArgumentException("Could not find source node for connection:" + connection.getSourceRef());
                        }
                    }
                    try {
                        targetRef = targetRef.substring(1);
                        targetRef = targetRef.substring(targetRef.lastIndexOf("-") + 1);
                        target = nodeContainer.getNode((long)new Integer(targetRef).intValue());
                    }
                    catch (NumberFormatException e) {
                        for (Node node : nodeContainer.getNodes()) {
                            if (!connection.getTargetRef().equals(node.getMetaData("UniqueId"))) continue;
                            target = node;
                            break;
                        }
                        if (target != null) break block16;
                        throw new IllegalArgumentException("Could not find target node for connection:" + connection.getTargetRef());
                    }
                }
                ConnectionImpl result = new ConnectionImpl(source, "DROOLS_DEFAULT", target, "DROOLS_DEFAULT");
                result.setMetaData("bendpoints", (Object)connection.getBendpoints());
                if (!(source instanceof Split)) continue;
                Split split = (Split)source;
                ConstraintImpl constraint = new ConstraintImpl();
                String defaultConnection = (String)split.getMetaData("Default");
                if (defaultConnection != null && defaultConnection.equals(connection.getId())) {
                    constraint.setDefault(true);
                }
                if (connection.getName() != null) {
                    constraint.setName(connection.getName());
                } else {
                    constraint.setName("");
                }
                if (connection.getType() != null) {
                    constraint.setType(connection.getType());
                } else {
                    constraint.setType("code");
                }
                if (connection.getLanguage() != null) {
                    constraint.setDialect(connection.getLanguage());
                }
                if (connection.getExpression() != null) {
                    constraint.setConstraint(connection.getExpression());
                }
                split.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), (Constraint)constraint);
            }
        }
    }

    public static void linkBoundaryEvents(NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            CompositeContextNode compositeNode;
            Node attachedNode;
            String type;
            String attachedTo;
            block9: {
                if (!(node instanceof EventNode) || (attachedTo = (String)node.getMetaData("AttachedTo")) == null) continue;
                type = ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).getType();
                attachedNode = null;
                try {
                    String attachedToString = attachedTo.substring(1);
                    attachedToString = attachedToString.substring(attachedToString.lastIndexOf("-") + 1);
                    attachedNode = nodeContainer.getNode((long)new Integer(attachedToString).intValue());
                }
                catch (NumberFormatException e) {
                    for (Node subnode : nodeContainer.getNodes()) {
                        if (!attachedTo.equals(subnode.getMetaData("UniqueId"))) continue;
                        attachedNode = subnode;
                        break;
                    }
                    if (attachedNode != null) break block9;
                    throw new IllegalArgumentException("Could not find node to attach to: " + attachedTo);
                }
            }
            if (type.startsWith("Escalation-")) {
                boolean cancelActivity = (Boolean)node.getMetaData("CancelActivity");
                compositeNode = (CompositeContextNode)attachedNode;
                ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
                if (exceptionScope == null) {
                    exceptionScope = new ExceptionScope();
                    compositeNode.addContext((Context)exceptionScope);
                    compositeNode.setDefaultContext((Context)exceptionScope);
                }
                String escalationCode = (String)node.getMetaData("EscalationEvent");
                ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                exceptionHandler.setAction((DroolsAction)new DroolsConsequenceAction("java", (cancelActivity ? "((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", null);"));
                exceptionScope.setExceptionHandler(escalationCode, (ExceptionHandler)exceptionHandler);
                continue;
            }
            if (type.startsWith("Error-")) {
                CompositeContextNode compositeNode2 = (CompositeContextNode)attachedNode;
                ExceptionScope exceptionScope = (ExceptionScope)compositeNode2.getDefaultContext("ExceptionScope");
                if (exceptionScope == null) {
                    exceptionScope = new ExceptionScope();
                    compositeNode2.addContext((Context)exceptionScope);
                    compositeNode2.setDefaultContext((Context)exceptionScope);
                }
                String errorCode = (String)node.getMetaData("ErrorEvent");
                ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                exceptionHandler.setAction((DroolsAction)new DroolsConsequenceAction("java", "((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();kcontext.getProcessInstance().signalEvent(\"Error-" + attachedTo + "-" + errorCode + "\", null);"));
                exceptionScope.setExceptionHandler(errorCode, (ExceptionHandler)exceptionHandler);
                continue;
            }
            if (type.startsWith("Timer-")) {
                boolean cancelActivity = (Boolean)node.getMetaData("CancelActivity");
                compositeNode = (CompositeContextNode)attachedNode;
                String timeCycle = (String)node.getMetaData("TimeCycle");
                Timer timer = new Timer();
                timer.setDelay(timeCycle);
                compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", (cancelActivity ? "((org.drools.workflow.instance.NodeInstance) kcontext.getNodeInstance()).cancel();" : "") + "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeCycle + "\", null);"));
                continue;
            }
            if (!type.startsWith("Compensate-")) continue;
            String uniqueId = (String)node.getMetaData("UniqueId");
            String eventType = "Compensate-" + uniqueId;
            ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
        }
    }

    private void assignLanes(RuleFlowProcess process, List<Lane> lanes) {
        ArrayList<String> laneNames = new ArrayList<String>();
        HashMap<String, String> laneMapping = new HashMap<String, String>();
        if (lanes != null) {
            for (Lane lane : lanes) {
                String name = lane.getName();
                if (name == null) continue;
                Swimlane swimlane = new Swimlane();
                swimlane.setName(name);
                process.getSwimlaneContext().addSwimlane(swimlane);
                laneNames.add(name);
                for (String flowElementRef : lane.getFlowElements()) {
                    laneMapping.put(flowElementRef, name);
                }
            }
        }
        this.assignLanes((NodeContainer)process, laneMapping);
    }

    private void postProcessNodes(NodeContainer container) {
        for (Node node : container.getNodes()) {
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                String condition = (String)stateNode.getMetaData("Condition");
                ConstraintImpl constraint = new ConstraintImpl();
                constraint.setConstraint(condition);
                constraint.setType("rule");
                for (Connection connection : stateNode.getDefaultOutgoingConnections()) {
                    stateNode.setConstraint(connection, (Constraint)constraint);
                }
                continue;
            }
            if (!(node instanceof NodeContainer)) continue;
            this.postProcessNodes((NodeContainer)node);
        }
    }

    private void assignLanes(NodeContainer nodeContainer, Map<String, String> laneMapping) {
        for (Node node : nodeContainer.getNodes()) {
            String lane = null;
            String uniqueId = (String)node.getMetaData("UniqueId");
            lane = uniqueId != null ? laneMapping.get(uniqueId) : laneMapping.get(XmlBPMNProcessDumper.getUniqueNodeId(node));
            if (lane != null) {
                ((NodeImpl)node).setMetaData("Lane", (Object)lane);
                if (node instanceof HumanTaskNode) {
                    ((HumanTaskNode)node).setSwimlane(lane);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.assignLanes((NodeContainer)node, laneMapping);
        }
    }
}

