/*
 * Decompiled with CFR 0.152.
 */
package org.drools.bpmn2.legacy.beta1;

import java.util.ArrayList;
import java.util.Map;
import org.drools.bpmn2.core.Message;
import org.drools.bpmn2.legacy.beta1.AbstractNodeHandler;
import org.drools.compiler.xml.ProcessBuildData;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.process.core.timer.Timer;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.StateNode;
import org.drools.workflow.core.node.TimerNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediateCatchEventHandler
extends AbstractNodeHandler {
    protected Node createNode(Attributes attrs) {
        return new EventNode();
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode(node, element, uri, localName, parser);
                break;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.handleMessageNode(node, element, uri, localName, parser);
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                TimerNode timerNode = new TimerNode();
                timerNode.setId(node.getId());
                timerNode.setName(node.getName());
                timerNode.setMetaData("UniqueId", node.getMetaData("UniqueId"));
                node = timerNode;
                this.handleTimerNode(node, element, uri, localName, parser);
                break;
            }
            if (!"conditionalEventDefinition".equals(nodeName)) continue;
            StateNode stateNode = new StateNode();
            stateNode.setId(node.getId());
            stateNode.setName(node.getName());
            stateNode.setMetaData("UniqueId", node.getMetaData("UniqueId"));
            node = stateNode;
            this.handleStateNode(node, element, uri, localName, parser);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.drools.definition.process.Node)node);
        return node;
    }

    protected void handleSignalNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, eventNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("signalRef")) == null || type.trim().length() <= 0) continue;
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType(type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void handleMessageNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, eventNode);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            eventNode.setMetaData("MessageType", (Object)message.getType());
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Message-" + messageRef);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void handleTimerNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        TimerNode timerNode = (TimerNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            Timer timer = new Timer();
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    String period = subNode.getTextContent();
                    timer.setDelay(period);
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            timerNode.setTimer(timer);
        }
    }

    protected void handleStateNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StateNode stateNode = (StateNode)node;
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"conditionalEventDefinition".equals(nodeName)) continue;
            for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                String subnodeName = subNode.getNodeName();
                if (!"condition".equals(subnodeName)) continue;
                stateNode.setMetaData("Condition", (Object)xmlNode.getTextContent());
                continue block0;
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, EventNode eventNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        subNode = subNode.getNextSibling();
        String to = subNode.getTextContent();
        eventNode.setVariableName(to);
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

