/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceType {
    private String name;
    private String description;
    private static final Map<String, ResourceType> CACHE = Collections.synchronizedMap(new HashMap());
    public static final ResourceType DRL = ResourceType.addResourceTypeToRegistry("DRL", "Drools Rule Language");
    public static final ResourceType XDRL = ResourceType.addResourceTypeToRegistry("XDRL", "Drools XML Rule Language");
    public static final ResourceType DSL = ResourceType.addResourceTypeToRegistry("DSL", "Drools DSL");
    public static final ResourceType DSLR = ResourceType.addResourceTypeToRegistry("DSLR", "Drools DSL Rule");
    public static final ResourceType DRF = ResourceType.addResourceTypeToRegistry("DRF", "Drools Rule Flow Language");
    public static final ResourceType DTABLE = ResourceType.addResourceTypeToRegistry("DTABLE", "Decision Table");
    public static final ResourceType PKG = ResourceType.addResourceTypeToRegistry("PKG", "Binary Package");
    public static final ResourceType BRL = ResourceType.addResourceTypeToRegistry("BRL", "Drools Business Rule Language");
    public static final ResourceType CHANGE_SET = ResourceType.addResourceTypeToRegistry("CHANGE_SET", "Change Set");

    public ResourceType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static ResourceType addResourceTypeToRegistry(String resourceType, String description) {
        ResourceType resource = new ResourceType(resourceType, description);
        CACHE.put(resourceType, resource);
        return resource;
    }

    public static ResourceType getResourceType(String resourceType) {
        ResourceType resource = CACHE.get(resourceType);
        if (resource == null) {
            throw new RuntimeException("Unable to determine resource type " + resourceType);
        }
        return resource;
    }

    public String toString() {
        return "ResourceType = '" + this.description + "'";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return this.name.equals(other.name);
    }
}

