package view.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JLabel;

import model.Gangfeld;

/**
 * 2D-Reprsentation des freien Gangfeldes
 * @author dgrosche
 * @version final 2010-05-07
 */
public class JGangfeld extends JLabel {

	private static final long serialVersionUID = -8523134546599904622L;
	private Gangfeld gangfeld;
	private int width, height;
	
	/**
	 * Erstellt eine neues 2D-Gangfeld
	 * @param g zu reprsentierendes Gangfeld
	 */
	public JGangfeld(Gangfeld g) {
		super();
		this.gangfeld = g;
		
		this.setMinimumSize(new Dimension(40, 40));
		this.setPreferredSize(new Dimension(60, 60));
	}
	
	/**
	 * Darstellung des Gangfeldes
	 */
	@Override
	public void paint(Graphics g) {
		Dimension d = this.getSize();
		width = (int) d.getWidth();
		height = (int) d.getHeight();
		
		switch(gangfeld.getTyp()) {
		case (Gangfeld.GERADE): this.paintGerade(g, gangfeld.getOrientation()); break;
		case (Gangfeld.KURVE): this.paintKurve(g, gangfeld.getOrientation()); break;
		case (Gangfeld.TSTUECK): this.paintTStueck(g, gangfeld.getOrientation()); break;
		}
	}
	
	/**
	 * Erstellen des T-Stcks
	 * @param g Grafik der Komponente
	 * @param rotation Rotierung des Feldes 
	 */
	private void paintTStueck(Graphics g, int rotation) {
		//Laden der Textur
		try {
			g.drawImage(ImageIO.read(new File("images/steine1.jpg")), 0, 0, width, height, this);
		} catch (IOException e) {
			g.clearRect(0, 0, width, height);
		}
		BufferedImage textur = null;
		try {
			textur = ImageIO.read(new File("images/brick.jpg"));
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		//Darstellung ohne Textur
		if(textur==null) {
			g.setColor(Color.RED);
			switch(rotation) {
				case 0: {
					g.fillRect(0, 0, width/5, height);
					g.fillRect(width-width/5, 0, width/5, height/5);
					g.fillRect(width-width/5, height-height/5, width/5, height/5);	
				} break;
				case 1: {
					g.fillRect(0, height-height/5, width, height/5);
					g.fillRect(0, 0, width/5, height/5);
					g.fillRect(width-width/5, 0, width/5, height/5);
				} break;
				case 2: {
					g.fillRect(width-width/5, 0, width/5, height);
					g.fillRect(0, 0, width/5, height/5);
					g.fillRect(0, height-height/5, width/5, height/5);
				} break;
				case 3: {
					g.fillRect(0, 0, width, height/5);
					g.fillRect(0, height-height/5, width/5, height/5);
					g.fillRect(width-width/5, height-height/5, width/5, height/5);
				} break;
			}
			
		//Darstellung mit Textur
		} else {
			switch(rotation) {
				case 0: {
					g.drawImage(textur, 0, 0, width/5, height, this);
					g.drawImage(textur, width-width/5, 0, width/5, height/5, this);
					g.drawImage(textur, width-width/5, height-height/5, width/5, height/5, this);	
				} break;
				case 1: {
					g.drawImage(textur, 0, height-height/5, width, height/5, this);
					g.drawImage(textur, 0, 0, width/5, height/5, this);
					g.drawImage(textur, width-width/5, 0, width/5, height/5, this);
				} break;
				case 2: {
					g.drawImage(textur, width-width/5, 0, width/5, height, this);
					g.drawImage(textur, 0, 0, width/5, height/5, this);
					g.drawImage(textur, 0, height-height/5, width/5, height/5, this);
				} break;
				case 3: {
					g.drawImage(textur, 0, 0, width, height/5, this);
					g.drawImage(textur, 0, height-height/5, width/5, height/5, this);
					g.drawImage(textur, width-width/5, height-height/5, width/5, height/5, this);
				} break;
			}
		}
	}
	
	/**
	 * Erstellen der Kurve
	 * @param g Grafik der Komponente
	 * @param rotation Rotierung des Feldes 
	 */
	private void paintKurve(Graphics g, int rotation) {
		//Laden der Textur
		try {
			g.drawImage(ImageIO.read(new File("images/steine1.jpg")), 0, 0, width, height, this);
		} catch (IOException e) {
			g.clearRect(0, 0, width, height);
		}
		BufferedImage textur = null;
		try {
			textur = ImageIO.read(new File("images/brick.jpg"));
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		//Darstellung ohne Textur
		if(textur==null) {
			g.setColor(Color.RED);
			switch(rotation) {
				case 0: {
					g.fillRect(width-width/5, 0, width/5, height);
					g.fillRect(0, height-height/5, width, height/5);
					g.fillRect(0, 0, width/5, height/5);
				} break;
				case 3: {
					g.fillRect(0, 0, width/5, height);
					g.fillRect(0, height-height/5, width, height/5);
					g.fillRect(width-width/5, 0, width/5, height/5);
				} break;
				case 2: {
					g.fillRect(0, 0, width/5, height);
					g.fillRect(0, 0, width, height/5);
					g.fillRect(width-width/5, height-height/5, width/5, height/5);
				} break;
				case 1: {
					g.fillRect(width-width/5, 0, width/5, height);
					g.fillRect(0, 0, width, height/5);
					g.fillRect(0, height-height/5, width/5, height/5);
				} break;
			}
			
		//Darstellung mit Textur
		} else {
			switch(rotation) {
				case 0: {
					g.drawImage(textur, width-width/5, 0, width/5, height, this);
					g.drawImage(textur, 0, height-height/5, width, height/5, this);
					g.drawImage(textur, 0, 0, width/5, height/5, this);
				} break;
				case 3: {
					g.drawImage(textur, 0, 0, width/5, height, this);
					g.drawImage(textur, 0, height-height/5, width, height/5, this);
					g.drawImage(textur, width-width/5, 0, width/5, height/5, this);
				} break;
				case 2: {
					g.drawImage(textur, 0, 0, width/5, height, this);
					g.drawImage(textur, 0, 0, width, height/5, this);
					g.drawImage(textur, width-width/5, height-height/5, width/5, height/5, this);
				} break;
				case 1: {
					g.drawImage(textur, width-width/5, 0, width/5, height, this);
					g.drawImage(textur, 0, 0, width, height/5, this);
					g.drawImage(textur, 0, height-height/5, width/5, height/5, this);
				} break;
			}
		}
	}
	
	/**
	 * Erstellen der Geraden
	 * @param g Grafik der Komponente
	 * @param rotation Rotierung des Feldes 
	 */
	private void paintGerade(Graphics g, int rotation) {
		//Laden der Textur
		try {
			g.drawImage(ImageIO.read(new File("images/steine1.jpg")), 0, 0, width, height, this);
		} catch (IOException e) {
			g.clearRect(0, 0, width, height);
		}
		BufferedImage textur = null;
		try {
			textur = ImageIO.read(new File("images/brick.jpg"));
		} catch (IOException e) {
			e.printStackTrace();
		}
		//Darstellung ohne Textur
		if(textur==null) {
			g.setColor(Color.RED);
			switch(rotation%2) {
				case 0: {
					g.fillRect(0, 0, width/5, height);
					g.fillRect(width-width/5, 0, width/5, height);
				} break;
				case 1: {
					g.fillRect(0, 0, width, height/5);
					g.fillRect(0, height-height/5, width, height/5);
				} break;
			}
			
		//Darstellung mit Textur
		} else {
			switch(rotation%2) {
				case 0: {
					g.drawImage(textur, 0, 0, width/5, height, this);
					g.drawImage(textur, width-width/5, 0, width/5, height, this);
				} break;
				case 1: {
					g.drawImage(textur, 0, 0, width, height/5, this);
					g.drawImage(textur, 0, height-height/5, width, height/5, this);
				} break;
			}	
		}
	}
	
	/**
	 * Setzt das reprsentierte Gangfeld der Komponente
	 * @param g zu reprsentierendes Gangfeld
	 */
	public void setGangfeld(Gangfeld g) {
		this.gangfeld = g;
		this.repaint();
	}

}
