package view.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import model.Gangfeld;
import model.SpielMgr;
import controler.behavior.EventListener;

/**
 * 2D-Bedienpanel
 * 
 * @author dgrosche
 * @version final 2010-05-07
 * 
 */
public class Bedienpanel extends JPanel implements Observer {

	private static final long serialVersionUID = -2014688731634542990L;
	private SpielMgr game;
	private EventListener e;
	private Hashtable<String, Component> komponenten = new Hashtable<String, Component>();

	/**
	 * Erstellt ein neues Bedienpanel
	 * 
	 * @param spiel
	 *            zugehrige Spiellogik
	 */
	public Bedienpanel(SpielMgr spiel) {
		this.game = spiel;
		e = new EventListener(game);
		game.addObserver(this);

		this.setLayout(new GridBagLayout());

		// Titellabel
		JLabel titel = new JLabel("Das verrckte Labyrinth");
		titel.setFont(new Font("Comic Sans MS", Font.PLAIN, 16));
		GridBagConstraints constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.gridwidth = 3;
		constraints.insets = new Insets(0, 0, 10, 0);
		this.add(titel, constraints);

		// Anzeige des aktuellen Spielers
		JLabel spielerLabel = new JLabel("Aktueller Spieler:");
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.insets = new Insets(0, 0, 0, 2);
		this.add(spielerLabel, constraints);

		JTextField spielerName = new JTextField(game.getCurrentPlayer()
				.getName());
		spielerName.setEditable(false);
		spielerName.setForeground(new Color(game.getCurrentPlayer()
				.getColor3f().getX(), game.getCurrentPlayer().getColor3f()
				.getY(), game.getCurrentPlayer().getColor3f().getZ()));
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 1;
		constraints.gridwidth = 2;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.insets = new Insets(0, 0, 2, 0);
		this.add(spielerName, constraints);
		komponenten.put("Spieler", spielerName);

		// Anzeige des nchsten Schatzes
		JLabel schatzLabel = new JLabel("Nchster Schatz:");
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 2;
		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.insets = new Insets(0, 0, 0, 2);
		this.add(schatzLabel, constraints);

		JTextField schatzName = new JTextField(game.getCurrentPlayer()
				.getSchatz().getName());
		schatzName.setEditable(false);
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 2;
		constraints.gridwidth = 2;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.insets = new Insets(0, 0, 2, 0);
		this.add(schatzName, constraints);
		komponenten.put("Schatz", schatzName);

		// Anzeige und Rotation des freien Gangfeldes
		JLabel fgLabel = new JLabel("Freies Gangfeld:");
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.insets = new Insets(0, 0, 0, 2);
		this.add(fgLabel, constraints);

		JGangfeld fgPaint = new JGangfeld(game.getFreiesGangfeld());
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 3;
		constraints.insets = new Insets(0, 0, 0, 5);
		this.add(fgPaint, constraints);
		komponenten.put("Gangfeld", fgPaint);

		JButton fgRotate = new JButton();
		try {
			fgRotate.setIcon(new ImageIcon(ImageIO.read(new File(
					"images/rotate.png"))));
		} catch (IOException e1) {
			fgRotate.setText("Rot");
		}
		fgRotate.setPreferredSize(fgPaint.getPreferredSize());
		constraints = new GridBagConstraints();
		constraints.gridx = 2;
		constraints.gridy = 3;
		fgRotate.addActionListener(e);
		fgRotate.setActionCommand("Rotation");
		this.add(fgRotate, constraints);
		komponenten.put("Rotation", fgRotate);

		// Verschiebung des Labyrinths
		JButton button = new JButton("Verschieben");
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 4;
		constraints.gridwidth = 3;
		constraints.insets = new Insets(5, 0, 0, 0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		button.setEnabled(false);
		button.addActionListener(e);
		button.setActionCommand("Verschieben");
		this.add(button, constraints);
		komponenten.put("Verschieben", button);

		// Beenden des Spielzugs
		JButton beenden = new JButton("Spielzug beenden");
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 5;
		constraints.gridwidth = 3;
		constraints.insets = new Insets(5, 0, 0, 0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		beenden.setEnabled(false);
		beenden.addActionListener(e);
		beenden.setActionCommand("Beenden");
		this.add(beenden, constraints);
		komponenten.put("Beenden", beenden);
	}

	/**
	 * Aktualisiert die Anzeige-Komponenten
	 */
	private void updateComponents() {
		if (komponenten.get("Gangfeld") instanceof JGangfeld)
			((JGangfeld) komponenten.get("Gangfeld")).setGangfeld(game
					.getFreiesGangfeld());
		if (komponenten.get("Spieler") instanceof JTextField) {
			JTextField spieler = (JTextField) komponenten.get("Spieler");
			spieler.setText(game.getCurrentPlayer().getName());
			spieler.setForeground(new Color(game.getCurrentPlayer()
					.getColor3f().getX(), game.getCurrentPlayer().getColor3f()
					.getY(), game.getCurrentPlayer().getColor3f().getZ()));
		}
		if (komponenten.get("Schatz") instanceof JTextField) {
			JTextField schatz = (JTextField) komponenten.get("Schatz");
			schatz.setText(game.getCurrentPlayer().getSchatz().getName());
		}

		this.repaint();
	}

	/**
	 * Aktualisiert das Bedienpanel anahnd des Models
	 * 
	 * @param o
	 *            Model (Spiellogik)
	 * @param arg
	 *            Argument bei der Aktualisierung (z.B. Randfeld der
	 *            Schiebeposition)
	 */
	@Override
	public void update(Observable o, Object arg) {
		if (o.equals(game)) {
			this.updateComponents();

			// Verschiebungs- und Rotationsbutton aktivieren
			if (game.getCurrentPhase() == SpielMgr.VERSCHIEBEN_PHASE) {
				if (arg instanceof Gangfeld) {
					game.setVerschiebung((Gangfeld) arg);
					((JButton) komponenten.get("Verschieben")).setEnabled(true);
				}
				((JButton) komponenten.get("Rotation")).setEnabled(true);
				((JButton) komponenten.get("Beenden")).setEnabled(false);

//				 Beenden-Button aktivieren
			} else if (game.getCurrentPhase() == SpielMgr.GEHEN_PHASE) {
				((JButton) komponenten.get("Verschieben")).setEnabled(false);
				((JButton) komponenten.get("Rotation")).setEnabled(false);
				((JButton) komponenten.get("Beenden")).setEnabled(true);
			}
		}
	}
}
