package view.j3d.treasureGraphics;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;

import view.j3d.Substanz;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;

/**
 * Schatz: Schatzkiste
 * 
 * @author dgrosche, jzimdars
 * @version final 2010-05-07
 * 
 */
public class Schatzkiste extends BranchGroup {

	/**
	 * Erstellt eine neue Schatzkiste
	 */
	public Schatzkiste() {
		Box kiste = new Box(new Float(0.75), new Float(0.5), new Float(0.5),
				new Appearance());
		Cylinder deckel = new Cylinder(new Float(0.5), new Float(1.5));

		// Erstelle Aussehen
		Appearance app = new Appearance();
		app.setMaterial(new Substanz(Substanz.KUPFER));
		kiste.setAppearance(app);
		deckel.setAppearance(app);

		// Drehe Zylinder
		Transform3D drehen = new Transform3D();
		drehen.rotZ(Math.toRadians(-90));
		TransformGroup hinlegen = new TransformGroup(drehen);
		hinlegen.addChild(deckel);

		// Verschiebe Zylinder
		Transform3D verschieben = new Transform3D();
		verschieben.setTranslation(new Vector3d(0.0, 0.5, 0.0));
		TransformGroup truhe = new TransformGroup(verschieben);
		truhe.addChild(hinlegen);

		// Leg die Truhe auf den Boden
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3d(0.0, -0.5, 0.0));
		TransformGroup tg = new TransformGroup(t3d);
		tg.addChild(kiste);
		tg.addChild(truhe);

		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
    
		TransformGroup transformBox = new TransformGroup();
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		Alpha alpha = new Alpha(-1, 5000);	
		
		float[] knots = {0.0f,0.5f,1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,1.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 0.0f, 1.0f);
		quats[1]= new Quat4f( 0.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, -1.0f);
		
		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
		posPath.setSchedulingBounds(new BoundingSphere());	
//		shape1.setAppearance(newAppearance);
		
		this.addChild(transformBox);
		this.addChild(posPath);
		transformBox.addChild(tg);
		
	}

}
