package view.j3d.treasureGraphics;

import java.awt.Color;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;

import view.j3d.treasureGraphics.unbboolean.BooleanModeller;
import view.j3d.treasureGraphics.unbboolean.BoxSolid;
import view.j3d.treasureGraphics.unbboolean.Solid;
import view.j3d.treasureGraphics.unbboolean.SphereSolid;

/**
 * Schatz: Ring
 * 
 * @author jzimdars
 * @version final 2010-05-07
 */
public class Ring extends BranchGroup {

	Shape3D shape1 = null;
	Shape3D shape2 = null;

	/**
	 * Erstellt ein neues Ring-Objekt
	 */
	public Ring() {
		this.getTreasure();
	}

	
private void getTreasure(){
		
		Solid field1 = createSolid1();
		shape1 = new Shape3D(field1.getGeometry());
		
		Solid field2 = createSolid2();
		shape2 = new Shape3D(field2.getGeometry());
		
		Solid field3 = createSolid3();
				
		
		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
    
		TransformGroup transformBox = new TransformGroup();
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		Alpha alpha = new Alpha(-1, 5000);	
		
		float[] knots = {0.0f,0.5f,1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,1.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 0.0f, 1.0f);
		quats[1]= new Quat4f( 0.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, -1.0f);
		
		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
		posPath.setSchedulingBounds(new BoundingSphere());	
		field3.setAppearance(newAppearance);
		shape1.setAppearance(newAppearance);
		shape2.setAppearance(newAppearance);
		
		TransformGroup tg = new TransformGroup();
		tg.addChild(field3);
		tg.addChild(shape1);
		tg.addChild(shape2);
		
		this.addChild(transformBox);
		this.addChild(posPath);
		transformBox.addChild(tg);
	}
	
	private Solid createSolid1(){
		Solid field = null;
		SphereSolid cylinder1 = new SphereSolid("", 0.3, 0.9, 0.9, new Color3f(Color.yellow));
		SphereSolid cylinder = new SphereSolid("x", 0.5, 0.7, 0.7, new Color3f(Color.yellow));
//		cylinder.rotate(Math.PI/2, 0); 
//		cylinder1.rotate(Math.PI/2, 0); 
//		cylinder.translate(0, 4);cylinder1.translate(0, 4);
//		box.translate(0, 4);
		BooleanModeller bm = new BooleanModeller(cylinder1, cylinder);
		field = bm.getDifference();
		field.scale(0.4, 0.4, 0.4);
		field.translate(0, -0.5);
		return field;
	}
	
	private Solid createSolid2(){
		Solid field = null;
		SphereSolid s1 = new SphereSolid("x", 0.25, 0.25, 0.25, new Color3f(Color.yellow));
		BoxSolid s2 = new BoxSolid("x", 1, 0.7, 0.7, new Color3f(Color.yellow));
		s1.translate(0, 0.6);
		s2.translate(0, 1.0);
		s1.scale(0.75, 0.75, 0.75);
		s2.scale(0.75, 0.75, 0.75);
//		s1.rotate(0, Math.PI/2); 
//		s2.rotate(0, Math.PI/2); 
		BooleanModeller bm2 = new BooleanModeller(s1, s2);
		field = bm2.getDifference();
		field.translate(0, -0.45);
		return field;
	}
	
	private Solid createSolid3(){
		SphereSolid s3 = new SphereSolid("x", 0.15, 0.15, 0.15, new Color3f(Color.green));
		return s3;
	}

}
