package view.j3d.treasureGraphics;

import java.awt.Color;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;

import view.j3d.treasureGraphics.unbboolean.BooleanModeller;
import view.j3d.treasureGraphics.unbboolean.CylinderSolid;
import view.j3d.treasureGraphics.unbboolean.Solid;
import view.j3d.treasureGraphics.unbboolean.SphereSolid;

/**
 * Schatz: Zauberstab
 * 
 * @author jzimdars
 * @version final 2010-05-07
 */
public class MagicWand extends BranchGroup {

	Shape3D shape1 = null;

	/**
	 * Erstellt ein neues Zauberstab-Objekt
	 */
	public MagicWand() {
		this.getTreasure();
	}
	
	private void getTreasure(){
		
		Solid field1 = createSolid2();
		shape1 = new Shape3D(field1.getGeometry());
		
		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
    
		TransformGroup transformBox = new TransformGroup();
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		Alpha alpha = new Alpha(-1, 5000);	
		
		float[] knots = {0.0f,0.5f,1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,1.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 0.0f, 1.0f);
		quats[1]= new Quat4f( 0.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, -1.0f);
		
		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
		posPath.setSchedulingBounds(new BoundingSphere());	
		shape1.setAppearance(newAppearance);
		
		TransformGroup tg = new TransformGroup();
		tg.addChild(shape1);
		
		this.addChild(transformBox);
		this.addChild(posPath);
		transformBox.addChild(tg);
		
	}
	
	private Solid createSolid2(){
		CylinderSolid cylinder1 = new CylinderSolid("", 1.1, 0.05, 0.05, new Color3f(Color.darkGray));
		cylinder1.translate(0, .3);
		SphereSolid s1 = new SphereSolid("", 0.07, 0.07, 0.07, new Color3f(Color.yellow));
		s1.translate(0, 0.9);
		BooleanModeller bm = new BooleanModeller(cylinder1, s1);
		Solid s = bm.getUnion();
		s.translate(-0, -1);
		s.rotate(45.0f * Math.PI / 180.0f, 0);
		return s;
	}
	

}