package view.j3d.treasureGraphics;

import java.awt.Color;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;

import view.j3d.treasureGraphics.unbboolean.BooleanModeller;
import view.j3d.treasureGraphics.unbboolean.BoxSolid;
import view.j3d.treasureGraphics.unbboolean.Solid;

/**
 * Schatz: Diamant
 * 
 * @author jzimdars
 * @version final 2010-05-07
 */
public class Diamond extends BranchGroup {

	Shape3D shape = null;
	Shape3D shape1 = null;
	Shape3D shape2 = null;
	Shape3D shape3 = null;

	/**
	 * Erstellt einen neuen Diamanten-Objekt
	 */
	public Diamond() {	
		this.getTreasure();
	}
	
	private void getTreasure(){
				
		Solid field1 = createSolid1();

		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
    
		TransformGroup transformBox = new TransformGroup();
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		Alpha alpha = new Alpha(-1, 5000);	
		
		float[] knots = {0.0f,0.5f,1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,1.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 0.0f, 1.0f);
		quats[1]= new Quat4f( 0.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, -1.0f);
	
		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
		posPath.setSchedulingBounds(new BoundingSphere());	
		field1.setAppearance(newAppearance);
		
		this.addChild(transformBox);
		this.addChild(posPath);
		transformBox.addChild(field1);
	}

	private Solid createSolid1(){
		BoxSolid b1 = new BoxSolid("x", 1, 1, 1, new Color3f(0.5f,1,0));
		BoxSolid b2 = new BoxSolid("x", 1, 1, 1, new Color3f(Color.green));
		b2.rotate(45.0f * Math.PI / 180.0f, 45.0f * Math.PI / 180.0f);
		Solid field = null;
		BooleanModeller bm = new BooleanModeller(b1, b2);
		field = bm.getIntersection();
		return field;
	}
	
	
}