package view.j3d.treasureGraphics;

import java.io.FileNotFoundException;
import java.io.FileReader;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;

/**
 * Schatz: Krone
 * 
 * @author jzimdars
 * @version final 2010-05-07
 * 
 */
public class Crown extends BranchGroup {

	Shape3D shape = null;
	Shape3D shape1 = null;
	Shape3D shape2 = null;
	Shape3D shape3 = null;

	/**
	 * Erstellt ein neues Kronen-Objekt
	 */
	public Crown() {
		
		this.loadObject("objects/crown.obj");
	}
	
	private void loadObject(String filename) {
		ObjectFile loader = new ObjectFile(ObjectFile.RESIZE);

		Scene scene = null;

		try {
			scene = loader.load(new FileReader(filename));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IncorrectFormatException e) {
			e.printStackTrace();
		} catch (ParsingErrorException e) {
			e.printStackTrace();
		}
//		Map<String, Shape3D> nameMap = scene.getNamedObjects();
//		for (String name : nameMap.keySet()) {
//			nameMap.get(name);
//		}
		
		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
    
		TransformGroup transformBox = new TransformGroup();
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		Alpha alpha = new Alpha(-1, 5000);	
		
		float[] knots = {0.0f,0.5f,1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,1.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 0.0f, 1.0f);
		quats[1]= new Quat4f( 0.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, -1.0f);
		
		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
		posPath.setSchedulingBounds(new BoundingSphere());
		
		TransformGroup tg = new TransformGroup();
		tg.addChild(scene.getSceneGroup());
		
		this.addChild(transformBox);
		this.addChild(posPath);
		transformBox.addChild(tg);
		
	}

}