package view.j3d.treasureGraphics;

import java.awt.Color;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationPathInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;

import view.j3d.treasureGraphics.unbboolean.BooleanModeller;
import view.j3d.treasureGraphics.unbboolean.BoxSolid;
import view.j3d.treasureGraphics.unbboolean.Solid;

/**
 * Schatz: Buch
 * 
 * @author jzimdars
 * @version final 2010-05-07
 * 
 */
public class Book extends BranchGroup {

	Shape3D shape1 = null;
	/**
	 * Erstellt ein Buch-Objekt
	 */
	public Book() {

		this.getTreasure();

	}

	/**
	 * @return BranchGroup des Buches
	 */
	
	private void getTreasure(){
		
		Solid field1 = createSolid1();	
		shape1 = new Shape3D(field1.getGeometry());
		
		
		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
    
		TransformGroup transformBox = new TransformGroup();
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		Alpha alpha = new Alpha(-1, 5000);	
		
		float[] knots = {0.0f,0.5f,1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,1.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 0.0f, 1.0f);
		quats[1]= new Quat4f( 0.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, -1.0f);
		
		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
		posPath.setSchedulingBounds(new BoundingSphere());	
		shape1.setAppearance(newAppearance);
		
		this.addChild(transformBox);
		this.addChild(posPath);
		transformBox.addChild(shape1);
		
	}

	private Solid createSolid1(){
		BoxSolid b1 = new BoxSolid("", 0.35,1.5,1.5, new Color3f(Color.blue));
		BoxSolid b2 = new BoxSolid("", 0.25,1.5,1.5, new Color3f(Color.white));
		b2.translate(1.4, 0.1);
		BooleanModeller bm1 = new BooleanModeller(b1, b2);
		Solid field1 = bm1.getDifference();
		BoxSolid b3 = new BoxSolid("", 0.25,1.5,1.5, new Color3f(Color.white));
		b3.translate(-1.4, 0.1);
		BooleanModeller bm2 = new BooleanModeller(field1, b3);
		Solid field2 = bm2.getDifference();
		BoxSolid b4 = new BoxSolid("", 0.25,0.9,1.5, new Color3f(Color.white));
		b4.translate(0, 1.15);
		BooleanModeller bm3 = new BooleanModeller(field2, b4);
		Solid field3 = bm3.getDifference();
		field3.rotate(90.0f * Math.PI / 180.0f, 90.0f * Math.PI / 180.0f);
		field3.translate(0.5, -0.7);
		
		
		return field3;
	}
	
	
}