package view.j3d;

import java.util.Enumeration;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;

import exceptions.GangfeldNotFoundException;

/**
 * Gibt den Szenegraph als String zurck
 * @author dgrosche
 * @version final 2010-05-07
 */
public class Szenengraphdrucker {
	
	private BranchGroup root;
	private int hierarchie;
	@SuppressWarnings("unused")
	private Spielbrett board;
	
	/**
	 * Erstellt einen Szenegraphdrucker
	 * @param root Wurzelknoten
	 */
	public Szenengraphdrucker(BranchGroup root) {
		this.root = root;
		this.hierarchie = 0;
	}
	
	/**
	 * Geht rekursiv den Szenegraph durch
	 * 
	 * @param node Aktueller Knoten
	 * @return String mit allen Child-Elementen des Knoten
	 * @throws GangfeldNotFoundException wenn kein passendes Gangfeld
	 */
	@SuppressWarnings("unchecked")
	private String printSceneGraph(Group node) throws GangfeldNotFoundException {
		String erg = "";
		this.hierarchie++;
		Enumeration children = node.getAllChildren();
		while(children.hasMoreElements()) {
			Object child = children.nextElement();
			erg +="\n"+this.hierarchie + ": "+child;
			if(child instanceof Spielbrett) {
				board = (Spielbrett) child;
				erg += this.printSceneGraph((Group) child);
			} else if(child instanceof GangfeldBG) {
//				erg+=" "+board.getGangfeld((GangfeldBG) child);
			} else if(child instanceof SchatzBG) {
//				erg+=" "+board.getSchatz((SchatzBG) child);
				erg += this.printSceneGraph((Group) child);
			} else if(child instanceof Spielfigur) {
//				erg+=" "+board.getSpieler((Spielfigur) child);
				erg += this.printSceneGraph((Group) child);
			} else if(child instanceof Group) {
				erg+=this.printSceneGraph((Group) child);
			}
		}
		this.hierarchie--;
		return erg;
	}
	
	/**
	 * @return Szenengraph-String
	 */
	@Override
	public String toString() {
		try {
			return this.printSceneGraph(this.root);
		} catch (GangfeldNotFoundException e) {
			e.printStackTrace();
		}
		return "";
	}

}
