package view.j3d;

import javax.media.j3d.Material;
import javax.vecmath.Color3f;

/**
 * Hier sind die Materialien aus der VL gespeichert
 * 
 * @author dgrosche, jzimdars
 * @version final 2010-05-07
 * 
 */
public class Substanz extends Material {

	// Die Indizies der Materialien sind ffentlich verfgbar
	protected static final int PLASTIK = 0;
	protected static final int GUMMI = 1;
	protected static final int MESSING = 2;
	protected static final int BRONZE = 3;
	protected static final int CHROM = 4;
	public static final int KUPFER = 5;
	protected static final int GOLD = 6;
	protected static final int ZINN = 7;
	protected static final int SILBER = 8;
	protected static final int SMARAGD = 9;
	protected static final int JADE = 10;
	protected static final int OBSIDIAN = 11;
	protected static final int PERLE = 12;
	protected static final int RUBIN = 13;
	protected static final int TUERKIS = 14;

	// Die Gestaltung ist intern in Arrays gespeichert
	private static final float[] shine = { 32f, 10f, 27.9f, 25.6f, 76.8f,
			12.8f, 51.2f, 9.8f, 51.2f, 76.8f, 12.8f, 38.4f, 11.3f, 76.8f, 12.8f };
	private static final Color3f[][] matrix = {
			{ new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.01f, 0.01f, 0.01f),
					new Color3f(0.5f, 0.5f, 0.5f) },
			{ new Color3f(0.02f, 0.02f, 0.02f),
					new Color3f(0.01f, 0.01f, 0.01f),
					new Color3f(0.4f, 0.4f, 0.4f) },
			{ new Color3f(0.33f, 0.22f, 0.03f),
					new Color3f(0.78f, 0.57f, 0.11f),
					new Color3f(0.99f, 0.94f, 0.81f) },
			{ new Color3f(0.21f, 0.13f, 0.5f),
					new Color3f(0.71f, 0.43f, 0.18f),
					new Color3f(0.39f, 0.27f, 0.17f) },
			{ new Color3f(0.25f, 0.25f, 0.25f),
					new Color3f(0.40f, 0.40f, 0.40f),
					new Color3f(0.77f, 0.77f, 0.77f) },
			{ new Color3f(0.19f, 0.07f, 0.02f),
					new Color3f(0.70f, 0.27f, 0.08f),
					new Color3f(0.26f, 0.14f, 0.09f) },
			{ new Color3f(0.25f, 0.20f, 0.07f),
					new Color3f(0.75f, 0.61f, 0.23f),
					new Color3f(0.63f, 0.56f, 0.37f) },
			{ new Color3f(0.11f, 0.06f, 0.11f),
					new Color3f(0.43f, 0.47f, 0.54f),
					new Color3f(0.33f, 0.33f, 0.52f) },
			{ new Color3f(0.19f, 0.19f, 0.19f),
					new Color3f(0.51f, 0.51f, 0.51f),
					new Color3f(0.51f, 0.51f, 0.51f) },
			{ new Color3f(0.02f, 0.17f, 0.02f),
					new Color3f(0.08f, 0.61f, 0.08f),
					new Color3f(0.63f, 0.73f, 0.63f) },
			{ new Color3f(0.14f, 0.22f, 0.16f),
					new Color3f(0.54f, 0.89f, 0.63f),
					new Color3f(0.32f, 0.32f, 0.32f) },
			{ new Color3f(0.05f, 0.05f, 0.07f),
					new Color3f(0.18f, 0.17f, 0.23f),
					new Color3f(0.33f, 0.33f, 0.35f) },
			{ new Color3f(0.25f, 0.21f, 0.21f),
					new Color3f(0.99f, 0.99f, 0.83f),
					new Color3f(0.30f, 0.30f, 0.30f) },
			{ new Color3f(0.17f, 0.01f, 0.01f),
					new Color3f(0.61f, 0.04f, 0.04f),
					new Color3f(0.73f, 0.63f, 0.63f) },
			{ new Color3f(0.10f, 0.19f, 0.17f),
					new Color3f(0.40f, 0.74f, 0.69f),
					new Color3f(0.30f, 0.31f, 0.31f) } };

	/**
	 * Erstellt ein neues Material mit den VL-Werten
	 * 
	 * @param material
	 *            Ganzzahliger Materialindex (siehe Konstanten)
	 */
	public Substanz(int material) {
		super(matrix[material][0], new Color3f(0.0f, 0.0f, 0.0f),
				matrix[material][1], matrix[material][2], shine[material]);
	}

	/**
	 * Erstellt ein neues Material mit einer bestimmten Farbe, gut fr Plastik,
	 * Gummi, Chrom
	 * 
	 * @param material
	 *            Ganzzahliger Materialindex (siehe Konstanten)
	 * @param farbe
	 *            ambiente Farbe des Materials
	 */
	protected Substanz(int material, Color3f farbe) {
		super(matrix[material][0], new Color3f(0.0f, 0.0f, 0.0f),
				matrix[material][1], matrix[material][2], shine[material]);
		super.setAmbientColor(farbe);
	}

	/**
	 * Erstellt ein neues Material, auch polierte Edelmetalle (Kupfer, Bronze,
	 * Silber, Gold)
	 * 
	 * @param material
	 *            Ganzzahliger Materialindex (siehe Konstanten)
	 * @param poliert
	 *            wenn das Edelmetall poliert dargestellt werden soll
	 */
	protected Substanz(int material, boolean poliert) {
		super(matrix[material][0], new Color3f(0.0f, 0.0f, 0.0f),
				matrix[material][1], matrix[material][2], shine[material]);
		if (poliert) {
			switch (material) {
			case Substanz.KUPFER: {
				super.setAmbientColor(.23f, .09f, .03f);
				super.setDiffuseColor(.55f, .21f, .07f);
				super.setSpecularColor(.58f, .22f, .07f);
				super.setShininess(51.2f);
			}
			case Substanz.BRONZE: {
				super.setAmbientColor(.25f, .15f, .06f);
				super.setDiffuseColor(.40f, .24f, .10f);
				super.setSpecularColor(.77f, .46f, .20f);
				super.setShininess(76.8f);
			}
			case Substanz.SILBER: {
				super.setAmbientColor(.23f, .23f, .23f);
				super.setDiffuseColor(.28f, .28f, .28f);
				super.setSpecularColor(.77f, .77f, .77f);
				super.setShininess(89.6f);
			}
			case Substanz.GOLD: {
				super.setAmbientColor(.25f, .22f, .06f);
				super.setDiffuseColor(.35f, .31f, .09f);
				super.setSpecularColor(.80f, .72f, .21f);
				super.setShininess(83.2f);
			}
			}
		}
	}

}
