package view.j3d;

import java.awt.Component;
import java.awt.GraphicsConfiguration;

import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.RotPosPathInterpolator;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

import model.SpielMgr;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;

import controler.behavior.AuswahlVerhalten;

/**
 * 3D-Umgebung des Spiels
 * 
 * @author dgrosche, jzimdars, cdiaspero
 * @version 160 2010-06-14
 * 
 */

public class Spielwelt {
	// Hintergrundfarbe
//	private Color3f backgroundColor = new Color3f(0.5f, 0.5f, 0.6f);

	// Group-Elemente
	private TransformGroup tmpTransformGroup;
	private Transform3D tmpTransform3d;
	private BranchGroup scene;
	private TransformGroup rootTransformGroup;
	private TransformGroup sceneTransformGroup;
	private TransformGroup pickTransformGroup;

	// Logik-Elemente
	private Spielbrett board;
	private SpielMgr game;
	private Canvas3D canvas;

	// Camera Animation
	private SimpleUniverse simpleU;
	

	/**
	 * Erstellen des Spiels
	 * 
	 * @param game
	 *            zu verwendende Spielzustnde
	 */
	public Spielwelt(SpielMgr game) {
		this.game = game;
		GraphicsConfiguration config = SimpleUniverse
				.getPreferredConfiguration();
		canvas = new Canvas3D(config);
		simpleU = new SimpleUniverse(canvas);
		simpleU.getViewingPlatform().setNominalViewingTransform();
		scene = new BranchGroup();
		scene.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
		Transform3D tmpTrans = new Transform3D();
		tmpTrans.set(0.01f);
		rootTransformGroup = new TransformGroup(tmpTrans);
		sceneTransformGroup = new TransformGroup();
		scene.addChild(sceneTransformGroup);
		sceneTransformGroup.addChild(rootTransformGroup);
		setUpBackground();
		createSpielbrett();
		setUpLight();
		setUpMouseBehavior();

		scene.compile();
		simpleU.addBranchGraph(scene);
		// System.out.println(new Szenengraphdrucker(scene));
		
		setUpCameraAnimation();
		
		
	}
	
	private void setUpCameraAnimation(){
		BranchGroup bg = new BranchGroup();
		Alpha alpha = new Alpha(1, 10000);
		Transform3D axisOfRotPos = new Transform3D();
		AxisAngle4f axis = new AxisAngle4f(0.0f,0.0f,0.0f,0.0f);
		axisOfRotPos.set(axis);
		float[] knots = {
				0.0f,1.0f
		};
		Quat4f[] quats = new Quat4f[2];
		quats[0] = new Quat4f(1.0f,1.0f,1.0f,0.0f);
		quats[1] = new Quat4f(0.0f,0.0f,0.0f,1.0f);
		Point3f[] positions = new Point3f[2];
		positions[0] = new Point3f(0.0f,0.0f,70.0f);
		positions[1] = new Point3f(0.0f,0.0f,3.0f);
		RotPosPathInterpolator rotPosPath = new RotPosPathInterpolator(alpha, simpleU.getViewingPlatform().getViewPlatformTransform(), axisOfRotPos, knots, quats, positions);
		rotPosPath.setSchedulingBounds(new BoundingSphere());
		bg.addChild(rotPosPath);
		scene.addChild(bg);
	}

	/**
	 * Setzen des Hintergrunds
	 */
	private void setUpBackground() {
		 Background bgNode = new Background(new Color3f(0.0f, 0.0f, 0.0f));
		 bgNode.setApplicationBounds(new BoundingSphere(new Point3d(),
		 1000.0f));
				
				
		 BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0,
		 0.0),100.0);
		 Background bg = new Background();
		 bg.setApplicationBounds(bounds);
		 BranchGroup backGeoBranch = new BranchGroup();
		 Sphere sphereObj = new Sphere(1.1f, Sphere.GENERATE_NORMALS
		 | Sphere.GENERATE_NORMALS_INWARD
		 | Sphere.GENERATE_TEXTURE_COORDS, 100);
		 Appearance backgroundApp = sphereObj.getAppearance();
		 backGeoBranch.addChild(sphereObj);
		 bg.setGeometry(backGeoBranch);
		 LabTextureLoader ltl = new
		 LabTextureLoader("images/hawaiianfall_1152.jpg");
		 Texture texture = ltl.getImg().getTexture();
			 
		 backgroundApp.setTexture(texture);
			    
		 rootTransformGroup.addChild(bg);
	}

	/**
	 * Setzen des Lichtes. Licht besteht aus Grundbeleuchtung (AmbientLight),
	 * direkter Beleuchtung (DirectionalLight) und SpotLights.
	 */
	private void setUpLight() {
		// set AmbientLight
		AmbientLight lightA = new AmbientLight(true, new Color3f(0.5f, 0.5f,
				0.5f));
		lightA.setInfluencingBounds(new BoundingSphere(new Point3d(),
						10000.0f));
		 sceneTransformGroup.addChild(lightA);

		// set DirectionalLight
		DirectionalLight lightD1 = new DirectionalLight();
		lightD1.setColor(new Color3f(0.6f,0.6f,0.6f));
		lightD1.setInfluencingBounds(new BoundingSphere(new Point3d(),
						10000.0f));
		 sceneTransformGroup.addChild(lightD1);

		Point3f att = new Point3f();
		(new SpotLight()).getAttenuation(att);
		SpotLight spot1 = new SpotLight(true,
				new Color3f(1.0f, 0.0f, 0.0f),
				new Point3f(-0.5f,-0.5f,0.5f), att,
				new Vector3f(0.0f,0.0f,-1.0f),
				(float) (Math.PI/4),500f);

		spot1.setEnable(true);
		spot1.setInfluencingBounds(new BoundingSphere(new Point3d(), 10f));
		sceneTransformGroup.addChild(spot1);
		
		SpotLight spot2 = new SpotLight(true,
				new Color3f(0.0f, 1.0f, 0.0f),
				new Point3f(0.5f,-0.5f,0.5f), att,
				new Vector3f(0.0f,0.0f,-1.0f),
				(float) (Math.PI/4),500f);

		spot2.setEnable(true);
		spot2.setInfluencingBounds(new BoundingSphere(new Point3d(), 10f));
		sceneTransformGroup.addChild(spot2);
		
		SpotLight spot3 = new SpotLight(true,
				new Color3f(0.0f, 0.0f, 1.0f),
				new Point3f(-0.5f,0.5f,0.5f), att,
				new Vector3f(0.0f,0.0f,-1.0f),
				(float) (Math.PI/4),500f);

		spot3.setEnable(true);
		spot3.setInfluencingBounds(new BoundingSphere(new Point3d(), 10f));
		sceneTransformGroup.addChild(spot3);
		
		SpotLight spot4 = new SpotLight(true,
				new Color3f(1.0f, 1.0f, 0.0f),
				new Point3f(0.5f, 0.5f,0.5f), att,
				new Vector3f(0.0f,0.0f,-1.0f),
				(float) (Math.PI/4),500f);

		spot4.setEnable(true);
		spot4.setInfluencingBounds(new BoundingSphere(new Point3d(), 10f));
		sceneTransformGroup.addChild(spot4);
	}

	/**
	 * Setzen des Mausverhaltens
	 */
	private void setUpMouseBehavior() {
		// Manipulation zulassen
		rootTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		rootTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);

		// Zoom bei Mausradbewegung
		MouseWheelZoom myMouseZoom = new MouseWheelZoom();
		myMouseZoom.setTransformGroup(rootTransformGroup);
		myMouseZoom.setSchedulingBounds(new BoundingSphere(new Point3d(),
				100000.0f));
		scene.addChild(myMouseZoom);

		// Rotations bei drag-und-drop
		MouseRotate myMouseRotate = new MouseRotate();
		myMouseRotate.setTransformGroup(rootTransformGroup);
		myMouseRotate.setSchedulingBounds(new BoundingSphere(new Point3d(),
				100000.0f));
		scene.addChild(myMouseRotate);

		// Auswahl in Verschiebephase
		new AuswahlVerhalten(canvas, scene, new BoundingSphere(new Point3d(),
				1000.0f), game);
	}


	/**
	 * Erstellt das Spielbrett
	 */
	private void createSpielbrett() {

		tmpTransform3d = new Transform3D();
		tmpTransformGroup = new TransformGroup(tmpTransform3d);
		tmpTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		tmpTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		tmpTransformGroup.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		rootTransformGroup.addChild(tmpTransformGroup);
		board = new Spielbrett(180f, 6f, game);
		tmpTransformGroup.addChild(board);

		Appearance app = new Appearance();
		app.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ);
		app.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);
		Material mat = new Material(new Color3f(1.0f, 0.0f, 1.0f), new Color3f(
				0.0f, 0.0f, 1.0f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(
				0.0f, 0.0f, 0.0f), 10.f);
		app.setMaterial(mat);
		TransparencyAttributes TA = new TransparencyAttributes(
				TransparencyAttributes.FASTEST, 0.4f);
		app.setTransparencyAttributes(TA);

		Box pickHighlightBox = new Box(1.0f, 1.0f, 1.0f,
				Box.ENABLE_APPEARANCE_MODIFY, app);

		tmpTransform3d = new Transform3D();
		pickTransformGroup = new TransformGroup(tmpTransform3d);
		pickTransformGroup.addChild(pickHighlightBox);
		pickTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		pickTransformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		tmpTransformGroup = new TransformGroup();
		tmpTransformGroup.addChild(pickTransformGroup);

		rootTransformGroup.addChild(tmpTransformGroup);
	}

	/**
	 * @return Zeichenflche der 3D-Umgebung
	 */
	public Component getCanvas() {
		return this.canvas;
	}
}