package view.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

import model.Spieler;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;

/**
 * Eine Kegel-Spielfigur
 * 
 * @author dgrosche, jzimdars
 * @version final 2010-05-07
 * 
 */
public class Spielfigur extends BranchGroup {

	// Eigenschaften der Figur
	private double breite = 1.0;
	private Color3f farbe = new Color3f(0.0f, 0.0f, 1.0f);

	// Berechnete Eigenschaften
	private double hoehe;
	private double radius;
	private Spieler spieler;
	private Appearance app;
	
	private BranchGroup main = new BranchGroup();

	// Grafikprimitive
	private Cone kegel;
	private Sphere kugel;
	
	private TransparencyAttributes alpha;
	
	
	
	// Konstruktoren
	/**
	 * Erstellt eine Standard-Spielfigur der Hhe 3 in Blau
	 */
	protected Spielfigur() {
		this.setGroesse(this.breite);
		this.createFigur();
	}

	/**
	 * Erstellt eine spezifische Spielfigur
	 * 
	 * @param farbe
	 *            Farbe der Figur
	 * @param hoehe
	 *            Hhe der Figur
	 */
	protected Spielfigur(Color3f farbe) {
		this.farbe = farbe;
		this.setGroesse(breite);
		this.createFigur();
	}

	/**
	 * Erstellt eine neue Spielfigur aus einem Spieler
	 * 
	 * @param s
	 *            Spieler-Datenobjekt
	 */
	protected Spielfigur(Spieler s) {
		this(s.getColor3f());
		this.spieler = s;
	}
	
	/**
	 * Setzt Spielfigur auf deleted (nach Abspielen der Spielfigur-Animation)
	 */
	protected void setDeleted(){
		TransparencyAttributes alpha = new TransparencyAttributes();
		alpha.setTransparencyMode(TransparencyAttributes.BLENDED);
		alpha.setTransparency(1.0f);
		app.setTransparencyAttributes(alpha);
	}

	/**
	 * @return erstellte Figur
	 */
	private void createFigur() {
		// System.out.println(this.breite+" "+this.hoehe+" "+this.radius);
		
		// Erstelle Primitive
		this.setCapability(BranchGroup.ALLOW_DETACH);
		
		kegel = new Cone(new Float(this.breite / 2), new Float(this.hoehe
				- this.radius));
		kugel = new Sphere(new Float(this.radius));
		
		// Erstelle Aussehen
		app = new Appearance();

		alpha = new TransparencyAttributes();
		alpha.setTransparencyMode(TransparencyAttributes.BLENDED);
		alpha.setTransparency(0.0f);
		alpha.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);
		app.setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);
		app.setTransparencyAttributes(alpha);

		app.setMaterial(new Substanz(Substanz.PLASTIK, farbe));
		kegel.setAppearance(app);
		kugel.setAppearance(app);

		// Verschiebe Kugel auf Kegelspitze
		Transform3D verschieben = new Transform3D();
		verschieben
				.setTranslation(new Vector3d(0.0, 0.755 * this.hoehe / 2, 0.0));
		TransformGroup kegelspitze = new TransformGroup(verschieben);
		kegelspitze.addChild(kugel);

		// Verschiebe Figur auf den Boden
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3d(0.0, this.hoehe / 2 + 0.3, 0.0));
		TransformGroup figur = new TransformGroup(t3d);
		figur.addChild(kegel);
		figur.addChild(kegelspitze);

		Transform3D scale = new Transform3D();
		scale.setScale(6.0f);
		TransformGroup tg = new TransformGroup(scale);

		// Rckgabe der Figur
		tg.addChild(figur);
		main.addChild(tg);
		this.addChild(main);
	}

	/**
	 * @param dimension
	 *            zu setzende Dimension
	 */
	private void setGroesse(double dimension) {
		this.breite = 0.9 * dimension;
		this.hoehe = 2 * this.breite;
		this.radius = 0.35 * dimension;
	}

	/**
	 * Vergleicht Spielfigur mit einem Spieler
	 */
	@Override
	public boolean equals(Object o) {
		if (o instanceof Spieler) {
			return spieler.equals(o);
		}
		return super.equals(o);
	}

}
