package view.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.geometry.Box;

/**
 * Grafische Markierung der Zugmglichkeiten
 * 
 * @author jzimdars
 * @version final 2010-05-07
 */
public class PossibleArea extends BranchGroup {

	Box b;
	private static final Color3f RED = new Color3f(1.0f, 0.0f, 0.0f);
	private static final Color3f YELLOW = new Color3f(1.0f, 1.0f, 0.0f);
	private static final Color3f BLUE = new Color3f(0.0f, 0.0f, 1.0f);
	private static final Color3f GREEN = new Color3f(0.0f, 1.0f, 0.0f);

	/**
	 * Erstellt ein neues Markierungsfeld
	 * 
	 * @param color
	 *            Farbe des Feldes
	 */
	protected PossibleArea(String color) {
		Appearance ap = new Appearance();
		TransparencyAttributes alpha = new TransparencyAttributes();
		alpha.setTransparencyMode(TransparencyAttributes.BLENDED);
		alpha.setTransparency(0.8f);
		ap.setTransparencyAttributes(alpha);
		Color3f cred = new Color3f(0.1f, 0.1f, 0.1f);
		;
		if (color == "blue") {
			cred = BLUE;
		} else if (color == "red") {
			cred = RED;
		} else if (color == "yellow") {
			cred = YELLOW;
		} else if (color == "green") {
			cred = GREEN;
		}
		Color3f cwhite = new Color3f(0.1f, 0.1f, 0.1f);
		float shininess = 70f;
		Material red = new Material(cred, cwhite, cred, cwhite, shininess);
		ap.setMaterial(red);

		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3d(0.0, 6 / 2 + 0.3, 0.0));
		TransformGroup tg = new TransformGroup(t3d);

		b = new Box(10.0f, 0.0f, 10.0f, ap);

		tg.addChild(b);

		this.addChild(tg);
		this.setCapability(BranchGroup.ALLOW_DETACH);
	}

}
