package view.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureCubeMap;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.geometry.Box;

/**
 * Untergrund des Spielbretts und Umgebung der Spielwelt
 * 
 * @author jzimdars
 * @version final 2010-05-07
 */
public class BorderWall extends BranchGroup {

	// Dieses Variable reprsentiert den Texturkoordinaten-Generator
    private TexCoordGeneration genNormalMap;    
    // Die Cube Map
    private TextureCubeMap texCmap;
    // Die Sphere Map
    private Texture2D texSmap;
    
    // Position
    private float x;
    private float y;
    private float z;
   
    /**
     * Erstellt BorderWalls
     * 
     * @param x x-Position
     * @param y y-Position
     * @param z z-Position
     * @param tx Abstand x
     * @param ty Abstand y
     * @param tz Abstand z
     */
	public BorderWall(float x,float y,float z,float tx,float ty,float tz){

		this.x=x;
		this.y=y;
		this.z=z;
				
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3d(tx,ty,tz));
		TransformGroup tg = new TransformGroup(t3d);
		tg.addChild(createScenegraph());
		this.addChild(tg);
		
	}
	
	
	/**
	 * @return Szenengraph
	 */
	public BranchGroup createScenegraph(){
		
		
		// Hier wird der Wurzel-Knoten des Szenengraphen erzeugt
		BranchGroup objRoot = new BranchGroup();
		
				
		////////////////////////////////////////////////////////////////////////////////
		// Environment Mapping
		// In dem Anwendungsbeispiel wird eine Cube Environment Map erstellt, die fr 
		// die Beleuchtung einer Kugel genutzt werden kann.
		
		//*******************************************************************************
		// Die Cube Map bzw. die Sphere Map wird erstellt und
		// die notwendigen Texturen werden angelegt
		buildTextures();
		
		//*******************************************************************************
		// Ein Cube Map wird einem Appearance Objekt zugewiesen. 
		Appearance newAppearance = new Appearance();
        Material newMaterial = new Material(new Color3f(0.0f,0.0f,0.0f),
        				    new Color3f(0.3f,0.3f,0.3f),
        				    new Color3f(0.5f,0.5f,0.5f),
        				    new Color3f(0.4f,0.4f,0.4f),12.0f);
        newAppearance.setMaterial(newMaterial);                
        
        // Polygon Attribute, wird wird das Culling ausgeschaltet und die Polygone gefllt dargestellt. 
        PolygonAttributes polyAttr = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE, 0.0f);
        newAppearance.setPolygonAttributes(polyAttr);	
        
        // Textur Attribute 
        TextureAttributes texAttr = new TextureAttributes();
        
        // An dieser Stelle wird die Cube Map oder die Sphere Map 
        // mit den generierten Koordinaten zusammengefhrt. 
        TextureUnitState texUnitStates[] = new TextureUnitState[1];
        
        // Die Variable texSmap wird einegefgt, wenn eine Sphere Map erzeugt worden ist 
        texUnitStates[0] = new TextureUnitState(texSmap, texAttr, genNormalMap); //fr Cube = (texCmap, texAttr, genNormlalMap);
        // Die Variable texCmap wird einegefgt, wenn eine Sphere Map erzeugt worden ist 

        newAppearance.setTextureUnitState(texUnitStates);
        
		//*******************************************************************************
		// Die Kugel wird erstellt
		// Transform-Knoten fr die Kugel. 
		TransformGroup transformBox = new TransformGroup();	
		// Hier muss die Schreibberechtigung aktiviert werden, da ansonsten die Animation die Position der Kugel nicht
		// verndern kann. 
		transformBox.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE); 
		
		// Alpha-Objekt, dass die Zeit steuert. 
		@SuppressWarnings("unused")
		Alpha alpha = new Alpha(-1, 5000);	
		
		// Die Sttzstellen fr die Animation. 
		@SuppressWarnings("unused")
		float[] knots = {0.0f, 0.5f, 1.0f};
		Quat4f[] quats = new Quat4f[3];
		Transform3D axisOfRotPos = new Transform3D();
		
		AxisAngle4f axis = new AxisAngle4f(0.0f,1.0f,0.0f,0.0f);
		axisOfRotPos.set(axis);

		quats[0]= new Quat4f( 0.0f, 0.0f, 1.0f, 0.0f);
		quats[1]= new Quat4f( 1.0f, 1.0f, 0.0f, 0.0f);
		quats[2]= new Quat4f( 0.0f, 0.0f, 0.0f, 0.0f);
		
		// Hier wird eine Instanz der Klasse PositionPathInterpolator, durch die das
		// Objekt animiert wird. 
//		RotationPathInterpolator posPath = new RotationPathInterpolator(alpha, transformBox, axisOfRotPos, knots, quats); 
//		posPath.setSchedulingBounds(new BoundingSphere());	

		// An dieser Stelle ist eine Box oder eien Kugel zu erstllen und die Appearance ist der Box oder der Kugel
		// zu bergeben. 
		//Sphere box = new Sphere(5.0f, Sphere.GENERATE_NORMALS, 100, newAppearance);
		Box box = new Box(x,y,z,Box.GENERATE_NORMALS, newAppearance);
		
		
		// Damit die Box die Farbe ndern kann mssen die Schreibberechtigungen gesetzt werden
		box.setCapability(Box.ENABLE_APPEARANCE_MODIFY);
		// Das Material wird der Box zugewisen
		box.setAppearance(newAppearance);
				
		
		// Der Teilszenegraph wird erstellt. 
		objRoot.addChild(transformBox);
//		objRoot.addChild(posPath);
		transformBox.addChild(box);
        
		
		// Ende Environment Map
		////////////////////////////////////////////////////////////////////////////////
		
		
		// Dadurch wird der Hintergrund der Szene gendert
//		BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 200.0);
//		Color3f bgColor = new Color3f(0.05f, 0.05f, 0.0f);
//		Background bgNode = new Background(bgColor);
//		bgNode.setApplicationBounds(bs);
//		objRoot.addChild(bgNode);
		
		return objRoot;
	}
	
	
	
	/***
	 * Die Funktion erstellt die Cube Map oder eine Sphere Map
	 */
	private void buildTextures() {


		// Dieses Objekt erstellt Texturkoordinaten
		// Die Parameter geben an, dass es sich um ein 2D-Koordinaten
		// handelt
		// Der erste Parameter kann hier variiert werden
		// Hier kann wahlweise
		// - TexCoordGeneration.SPHERE_MAP zur Erzeugung einer Sphere Map eingegeben werden.
		// - TexCoordGeneration.REFLECTION_MAP zur Erzeugung einer Cube Map eingegben werden
		// ********************************************************************************************
		genNormalMap = new TexCoordGeneration(TexCoordGeneration.SPHERE_MAP, TexCoordGeneration.TEXTURE_COORDINATE_2);
		
		
	    // Hier wird die Cube Map erstellt. 
		texCmap = new TextureCubeMap(Texture.BASE_LEVEL, Texture.RGB, 1024);
		// Hier wird die Sphere Map erstell 
		texSmap = new Texture2D(Texture.BASE_LEVEL, Texture.RGB, 1024, 1024);
        
        // Der Java3D TexturLoader ldt Bilder aus jpg- und gif-Dateien. 
		// Das erste ATtribte ist der Name des Objektes. Das zweite Attribt ist der Observer, der den Ladevorgang berwacht.
		// Hier wird mit dem this-Zeiger auf die Applikation Kap_3_2_Texturen selbst verwiesen.
		LabTextureLoader ltl = new LabTextureLoader("images/Spheremap1.jpg");
//		Texture texture = ltl.getImg().getTexture();
		
		ImageComponent2D image = ltl.getImg().getImage();
		// Das Bild wird aus dem Loader geholt und in einem Objekt vom Type ImageComponent abgelegt. 
		// Das Objekt speichert die Bilddaten als Bildarray.
	    
		// Die ImageComponenten werden der den einzelnen Bilder zugewiesen
		ImageComponent2D imageC1 = image;
	    ImageComponent2D imageC2 = image;
	    ImageComponent2D imageC3 = image;
	    ImageComponent2D imageC4 = image;
	    ImageComponent2D imageC5 = image;
	    ImageComponent2D imageC6 = image;
	    
	    // ********************************************************************************************
		// In der Regel erstellen Sie entweder eine Sphere Map oder eine Cube Map. Beides
	    // ist nicht notwendig. Hier wird nur beides aus bungszwecken angelegt. 
	    
	    // Hier wird das Bild der Sphere Map zugewiesen. 
	    texSmap.setImage(0, image);

	    // Die Bilder werden jeder Seite einer Cube Map zugewiesen. 
	    texCmap.setImage(0,TextureCubeMap.POSITIVE_X,imageC1);
	    texCmap.setImage(0,TextureCubeMap.NEGATIVE_X,imageC2);
	    texCmap.setImage(0,TextureCubeMap.POSITIVE_Y,imageC3);
	    texCmap.setImage(0,TextureCubeMap.NEGATIVE_Y,imageC4);
	    texCmap.setImage(0,TextureCubeMap.POSITIVE_Z,imageC5);
	    texCmap.setImage(0,TextureCubeMap.NEGATIVE_Z,imageC6);
	}
}
