package view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import model.SpielMgr;
import view.j3d.Spielwelt;
import view.panel.Bedienpanel;

/**
 * Ausgabefenster des Spiels
 * 
 * @author dgrosche, jzimdars
 * @version final 2010-05-07
 *
 */
public class Fenster extends JFrame {
	
	private static final long serialVersionUID = 551357613837798666L;
	
	/**
	 * Erstellt ein neues Fenster
	 */
	public Fenster() {
		super("Das verrckte Labyrinth");
		
		//Anzahl der Spieler wird bestimmt. Die Zahl muss zwischen 2 und 4 liegen
		String input="";
		while(input.equals("")) {
			Object[] possibilities = {"2","3","4"};
			input = (String) JOptionPane.showInputDialog(
					this,
					"Spieler:",
					"Anzahl der Spieler:",
					JOptionPane.QUESTION_MESSAGE,
					null,
					possibilities,
					"2");
			input = (input==null) ? "" : input; 
		}
		int anzPlayer = Integer.parseInt(input);
		Vector<String> spielernamen = new Vector<String>();
		for(int i=1; i<=anzPlayer; i++) {
			input = "";
			while(input.equals("")) {
				input = (String) JOptionPane.showInputDialog(
						this,
						"Spieler "+i+":",
						"Name des "+i+". Spielers:",
						JOptionPane.QUESTION_MESSAGE);
				input = (input==null) ? "" : input; 
			}
			spielernamen.add(input);
		}
		SpielMgr spiel = new SpielMgr(spielernamen);
		
		Spielwelt world = new Spielwelt(spiel);
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(world.getCanvas(), BorderLayout.CENTER);
		
		this.setSize(1024, 600);
		JPanel bp = new Bedienpanel(spiel);
		bp.setMinimumSize(new Dimension(this.getWidth()-this.getHeight()-160, this.getHeight()));
		bp.setPreferredSize(new Dimension(this.getWidth()-this.getHeight()-160, this.getHeight()));
		this.getContentPane().add(bp, BorderLayout.EAST);
		
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);
	}
	
	/**
	 * Hauptprogramm erstellt das Fenster
	 */
	
	public static void main(String[] args) {
		new Fenster();
	}
}
