package model;

import javax.vecmath.Color3f;

/**
 * Datenobjekt fr den Spieler
 * 
 * @author jzimdars, cdiaspero
 * @version final 2010-05-07
 * 
 */
public class Spieler {

	// Anzahl bestimmt die Farbe
	private static int anzSpieler = 0;

	// Eigenschaften
	private int x;
	private int z;
	private boolean visible = true;
	private Color3f color = new Color3f(0.0f, 0.0f, 0.0f);
	private String name;
	private Schatz schatz = new Schatz("Leer");

	// Farben
	protected static final Color3f RED = new Color3f(1.0f, 0.0f, 0.0f);
	protected static final Color3f YELLOW = new Color3f(1.0f, 1.0f, 0.0f);
	protected static final Color3f BLUE = new Color3f(0.0f, 0.0f, 1.0f);
	protected static final Color3f GREEN = new Color3f(0.0f, 1.0f, 0.0f);

	/**
	 * Erstellt ein neues Spielerobjekt
	 * 
	 * @param x
	 *            x-Position (Reihe des Gangfeldes)
	 * @param z
	 *            z-Position (Spalte des Gangfeldes)
	 * @param name
	 *            Name des Spielers
	 */
	protected Spieler(int x, int z, String name) {
		anzSpieler++;
		this.x = x;
		this.z = z;
		if (anzSpieler == 1)
			this.color = Spieler.BLUE;
		if (anzSpieler == 2)
			this.color = Spieler.RED;
		if (anzSpieler == 3)
			this.color = Spieler.GREEN;
		if (anzSpieler == 4)
			this.color = Spieler.YELLOW;
		this.name = name;
	}

	/**
	 * Setzt die Position des Spieler
	 * 
	 * @param x
	 *            x-Position (Reihe des Gangfeldes)
	 * @param z
	 *            z-Position (Spalte des Gangfeldes)
	 */
	protected void setPosition(int x, int z) {
		this.x = x;
		this.z = z;
	}

	/**
	 * Setzt die Figur sichtbar
	 * 
	 * @param b
	 *            true = sichtbar
	 */
	public void setVisible(boolean b) {
		this.visible = b;
	}

	/**
	 * @param schatz
	 *            Nchster zu erreichender Schatz
	 */
	protected void setSchatz(Schatz schatz) {

		this.schatz = schatz;
	}

	/**
	 * @return Farbe des Spielers als Color3f
	 */
	public Color3f getColor3f() {
		return color;
	}

	/**
	 * @return Sichtbarkeit der Spielfigur
	 */
	public boolean getVisible() {
		return visible;
	}

	/**
	 * @return Farbe des Spieler als String
	 */
	public String getFarbe() {
		if (color.equals(Spieler.BLUE))
			return "blue";
		if (color.equals(Spieler.RED))
			return "red";
		if (color.equals(Spieler.GREEN))
			return "green";
		if (color.equals(Spieler.YELLOW))
			return "yellow";
		return null;
	}

	/**
	 * @return Position in der Form [Reihe|Spalte]
	 */
	public int[] getPosition() {
		int[] pos = new int[2];
		pos[0] = x;
		pos[1] = z;
		return pos;
	}

	/**
	 * @return Name des Spielers
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @return Nchster zu erreichender Schatz
	 */
	public Schatz getSchatz() {
		return schatz;
	}

	/**
	 * Entspricht Namen des Spielers
	 */
	@Override
	public String toString() {
		return name;
	}

}
