package model;


/**
 * Datenobjekt fr Schtze
 * 
 * @author dgrosche, cdiaspero
 * @version final 2010-05-07
 * 
 */
public class Schatz {

	private int[] position = new int[2];
	private String name;

	/**
	 * Erstellt einen neuen Schatz
	 * 
	 * @param xPos
	 *            x-Position des Schatzes
	 * @param yPos
	 *            y-Position des Schatzes
	 * @param name
	 *            Name/Typ des Schatzes
	 */
	protected Schatz(int xPos, int yPos, String name) {
		position[0] = xPos;
		position[1] = yPos;
		this.name = name;
	}

	/**
	 * @author cdiaspero
	 *         Erstellt einen neuen Schatz ohne Zuweisung der Position.
	 * 
	 * @param name
	 *            Name/Typ des Schatzes
	 */
	protected Schatz(String name) {
		this.name = name;
	}

	/**
	 * @param position
	 *            zu setzende Position als (x,y)-Paar
	 */
	protected void setPosition(int row, int col) {
		int[] pos = { row, col };
		this.position = pos;
	}

	/**
	 * @return Position als (x,y)-Paar
	 */
	public int[] getPosition() {
		return position;
	}

	/**
	 * @return Name/Typ des Schatzes
	 */
	public String getName() {
		return name;
	}

	/**
	 * Prft ob 2 Schtze gleich sind Gleichheit bedingt durch Name und Position
	 * 
	 * @param vergleich
	 *            Vergleichsobjekt (Schatz)
	 * @return true, wenn gleich
	 */
	@Override
	public boolean equals(Object vergleich) {
		if (vergleich instanceof Schatz) {
			Schatz s = (Schatz) vergleich;
			if (this.name.equals(s.getName())
					&& this.position[0] == s.getPosition()[0]
					&& this.position[1] == s.getPosition()[1])
				return true;
		}
		return false;
	}
	
	/**
	 * Gibt Namen und Position des Schatzes zurck
	 */
	@Override
	public String toString() {
		return this.getName()+" ("+position[0]+"|"+position[1]+")";
	}

}
