package model;

import java.util.Timer;
import java.util.TimerTask;

import view.j3d.Spielbrett;

/**
 * Hilfsklasse fr Spielfiguranimation
 * 
 * @author jzimdars
 * @version final 2010-05-07
 *
 */
public class MoveTimer {
	
	// Eigenschaften
	Timer timer;
	SpielMgr game;
	Spielbrett board;

	/**
	 * Erstellt einen neuen MoveTimer
	 * 
	 * @param miliseconds Dauer in ms
	 * @param g Spiel-Logik
	 * @param b Spielbrett (Grafik)
	 */
    public MoveTimer(int miliseconds, SpielMgr g, Spielbrett b) {
        this.game = g;
        this.board = b;
    	timer = new Timer();
        timer.schedule(new RemindTask(), miliseconds+100);
	}

    /**
     * Subklasse fr den Timer
     */
    class RemindTask extends TimerTask {
        public void run() {
            if(game!=null)game.setMovable(true, 0);
            if(board!=null)board.deleteAnimation();
            timer.cancel();
        }
    }
}
