package controler.behavior;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import model.SpielMgr;

/**
 * Wertet die Events des 2D-Spielpanels aus.
 * 
 * @author dgrosche
 * @version final 2010-05-07
 * 
 */
public class EventListener implements ActionListener {

	private SpielMgr game;

	/**
	 * Erstellt einen EventManager
	 * 
	 * @param spiel
	 *            zugehriges Spiel
	 */
	public EventListener(SpielMgr spiel) {
		this.game = spiel;
	}

	/**
	 * Ausfhren eines Mausklickevents
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() instanceof JButton) {
			JButton b = (JButton) e.getSource();
			// Verschieben des Gangfeldes
			if (b.getActionCommand().equals("Verschieben")) {
				Object o = game.verschieben();
				game.weiter();
				game.notifyObservers(o);
				// Rotieren des Gangfeldes
			} else if (b.getActionCommand().equals("Rotation")) {
				game.rotate(game.getFreiesGangfeld());
				game.notifyObservers();
				// Spielzug beenden
			} else if (b.getActionCommand().equals("Beenden")) {
				game.setAnimation(false);
				game.weiter();
				game.notifyObservers();
			}
		}
	}

}
