package controler.behavior;

import java.util.Enumeration;
import java.util.Vector;

import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;

import model.Gangfeld;
import model.SpielMgr;
import view.j3d.GangfeldBG;
import view.j3d.SchatzBG;

import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;

import exceptions.NoRandfeldException;

/**
 * Das Auswahlverhalten bei Anklicken eines Feldes oder eines Gegenstandes.
 * 
 * @author dgrosche, jzimdars
 * @version final 2010-05-07
 */
public class AuswahlVerhalten extends PickMouseBehavior {

	private PickResult pickResult = null;
	private TransformGroup transformGroup;
	private Gangfeld gangfeld;
	private SchatzBG schatz;
	private SpielMgr game;

	// Variablen zur Wegfindung
	private boolean goalNotFound = true;
	private int[][] wayCoords;
	private Gangfeld goal = null;

	/**
	 * Erstellt ein neues Auswahlverhalten fr die 3D-Umgebung
	 * 
	 * @param canvas
	 *            Zeichenflche der 3D-Umgebung
	 * @param root
	 *            Wurzelknoten des Szenegraphen
	 * @param bounds
	 *            Raum in welchem das Verhalten gltig ist
	 * @param game
	 *            Die aktuelle Spielwelt (Model)
	 */
	public AuswahlVerhalten(Canvas3D canvas, BranchGroup root, Bounds bounds,
			SpielMgr game) {

		super(canvas, root, bounds);

		this.setSchedulingBounds(bounds);
		this.game = game;
		root.addChild(this);
		pickCanvas.setMode(PickTool.BOUNDS);
	}

	/**
	 * Wertet einen Mausklick aus
	 * 
	 * @param xPos
	 *            x-Position des Mausklicks
	 * @param yPos
	 *            y-Position des Mausklicks
	 */
	@SuppressWarnings("unchecked")
	public void updateScene(int xPos, int yPos) {
		// Durchfhrung des eigentlichen Pickings
		pickCanvas.setShapeLocation(xPos, yPos);
		pickResult = pickCanvas.pickClosest();

		// Auslesen des Ergebnisses
		if (pickResult != null) {
			transformGroup = (TransformGroup) pickResult
					.getNode(PickResult.TRANSFORM_GROUP);
			Enumeration children = transformGroup.getAllChildren();
			if (children.hasMoreElements()) {
				Object child = children.nextElement();
				// Ein Gangfeld wurde ausgewhlt
				if (child instanceof GangfeldBG)
					this.setGangfeld((GangfeldBG) child);
				// Ein Schatz wurde ausgewhlt
				else if (child instanceof SchatzBG)
					schatz = (SchatzBG) schatz;
			}
		}

		// Auswerten des aktuellen Picks
		if (gangfeld != null) {
			if (game.getCurrentPhase() == SpielMgr.VERSCHIEBEN_PHASE) {
				// Pruefen ob gewaehltes Gangfeld zu verschiebbarer Spalte /
				// Reihe gehoert
				if (gangfeld.getRow() % 2 == 0
						&& gangfeld.getColumn() % 2 == 0
						&& gangfeld.getTyp() == Gangfeld.RAND
						&& !(gangfeld.getRow() == 0 && gangfeld.getColumn() == 0)
						&& !(gangfeld.getRow() == 0 && gangfeld.getColumn() == 8)
						&& !(gangfeld.getRow() == 8 && gangfeld.getColumn() == 0)
						&& !(gangfeld.getRow() == 8 && gangfeld.getColumn() == 8))
					this.highlightRandfeld();
			} else if (game.getCurrentPhase() == SpielMgr.GEHEN_PHASE) {
				this.moveFigur();
			}
		}
	}

	/**
	 * Markiert ein Randfeld
	 */
	private void highlightRandfeld() {
		// Ein Gangfeld wurde ausgewhlt und wird gehighlightet
		try {
			for (Gangfeld g : game.getAllGangfelder()) {
				if (g.getTyp() == Gangfeld.RAND) {
					game.highlightingRandfeld(g, false);
				}
			}
			game.highlightingRandfeld(gangfeld, true);
		} catch (NoRandfeldException e) {
			e.printStackTrace();
		}

		// Da eine nderung stattfand benachrichtigt das Model die Views
		game.notifyObservers(gangfeld);

	}

	/**
	 * Speichert das Gangfeld anhand der ausgewhlten BranchGroup
	 * 
	 * @param child
	 *            Ausgewhltes Gangfeld
	 */
	private void setGangfeld(GangfeldBG child) {
		for (Gangfeld g : game.getAllGangfelder()) {
			if (child.equals(g))
				this.gangfeld = g;
			this.pickResult = null;
		}
	}

	/**
	 * Verschiebt die Figur auf ein anderes Gangfeld
	 */
	private void moveFigur() {
		if (gangfeld.getWaymark() && game.getMovable()) {
			this.getShortestWay(game.getCurrentPlayer().getPosition()[0], game
					.getCurrentPlayer().getPosition()[1], gangfeld.getRow(),
					gangfeld.getColumn());

			game.movePlayer(gangfeld.getRow(), gangfeld.getColumn());
			game.setMovable(false, 1250 * (wayCoords.length - 1));
			game.setWayCoords(true);
			game.notifyObservers(wayCoords);
			game.printSpielzustand();
		}
	}

	/**
	 * Ermittelt den krzesten Weg zum Verscheiben der Spielfigur
	 * 
	 * @param startX
	 *            Reihe des Gangfeldes der Ausgangsposition
	 * @param startZ
	 *            Spalte des Gangfeldes der Ausgangsposition
	 * @param goalX
	 *            Reihe des Gangfeldes der Zielposition
	 * @param goalZ
	 *            Spalte des Gangfeldes der Zielposition
	 */
	private void getShortestWay(int startX, int startZ, int goalX, int goalZ) {

		// Liste mit allen zugnglichen Feldern
		Vector<Gangfeld> ways = new Vector<Gangfeld>();

		// Liste mit Feldern deren Nachbarn berprft werden mssen
		Vector<Gangfeld> openList = new Vector<Gangfeld>();

		// Liste mit allen abgeschlossenen Suchen
		Vector<Gangfeld> closedList = new Vector<Gangfeld>();

		// Liste des richtigen Weges
		Vector<Gangfeld> walkingPath = new Vector<Gangfeld>();

		for (Gangfeld g : game.getAllGangfelder()) {
			if (g.getWaymark()) {
				ways.add(g);
			}
		}
		for (Gangfeld g : ways) {
			if (g.getRow() == startX && g.getColumn() == startZ) {
				openList.add(g);
				System.out.println("Start:" + g.getRow() + " " + g.getColumn());
			}
			if (g.getRow() == goalX && g.getColumn() == goalZ) {
				goal = g;
				System.out.println("Goal:" + g.getRow() + " " + g.getColumn());
			}
		}
		while (goalNotFound) {
			executeOpenList(openList, ways, closedList);
			for (Gangfeld x : openList) {
				System.out.println("OpenList" + x.getRow() + " "
						+ x.getColumn());
			}
		}
		// Nachdem das Ziel gefunden wurde, wird der Weg zurckverfolgt der vom
		// Start aus gegangen wurde
		Gangfeld parent = goal.getParent();
		walkingPath.add(goal);
		System.out
				.println("yadsf" + parent.getRow() + " " + parent.getColumn());
		while (!(parent.getRow() == startX && parent.getColumn() == startZ)) {
			walkingPath.add(parent);

			parent = parent.getParent();

		}
		walkingPath.add(parent);
		Gangfeld[] path = new Gangfeld[walkingPath.size()];
		for (int i = path.length - 1; i >= 0; i--) {
			path[i] = walkingPath.get(walkingPath.size() - i - 1);
		}

		wayCoords = new int[path.length][2];
		for (int i = 0; i < path.length; i++) {
			System.out.println("Pfad: " + path[i].getRow() + " "
					+ path[i].getColumn());
			wayCoords[i][0] = path[i].getRow();
			wayCoords[i][1] = path[i].getColumn();
		}
		goalNotFound = true;
		goal = null;
		for (Gangfeld g : game.getAllGangfelder()) {
			g.removeParent();
		}
	}

	/**
	 * Unterteil zur Methode getShortestWay
	 * 
	 * @author jzimdars
	 */
	private void executeOpenList(Vector<Gangfeld> openList,
			Vector<Gangfeld> ways, Vector<Gangfeld> closedList) {
		Vector<Gangfeld> neighbours = new Vector<Gangfeld>();
		Vector<Gangfeld> openListNote = new Vector<Gangfeld>();
		// openList abgehen
		for (Gangfeld o : openList) {
			openListNote.add(o);
			Vector<Gangfeld> neighboursX = null;
			neighboursX = this.findNeighbours(o, ways, closedList);
			for (Gangfeld n : neighboursX) {
				neighbours.add(n);
				game.relationship(n, o);
				System.out.println("Field:" + n.getRow() + " " + n.getColumn()
						+ " Parent:" + o.getRow() + " " + o.getColumn());
			}
		}
		// Elemente lschen
		// Elemente der closedList hinzufgen
		for (Gangfeld o : openListNote) {
			openList.remove(o);
			closedList.add(o);
		}
		// Nachbarn der openList hinzufgen
		for (Gangfeld n : neighbours) {
			openList.add(n);
		}
	}

	/**
	 * Unterteil der Methode executeOpenList
	 * 
	 * @author jzimdars
	 */
	private Vector<Gangfeld> findNeighbours(Gangfeld a, Vector<Gangfeld> ways,
			Vector<Gangfeld> closedList) {
		Vector<Gangfeld> r = new Vector<Gangfeld>();
		for (Gangfeld g : ways) {
			// berprfen ob das Feld in der Nachbarschaft ist
			if (g.getRow() == a.getRow() + 1 && g.getColumn() == a.getColumn()
					|| g.getRow() == a.getRow() - 1
					&& g.getColumn() == a.getColumn()
					|| g.getColumn() == a.getColumn() + 1
					&& g.getRow() == a.getRow()
					|| g.getColumn() == a.getColumn() - 1
					&& g.getRow() == a.getRow()) {
				// berprfen ob Feld nochnicht durchsucht wurde
				if (this.checkClosedList(g, closedList)) {
					// berprfen ob keine Wand zwischen den Feldern ist
					if (this.checkWalls(a, g)) {
						if (g.equals(goal)) {
							goalNotFound = false;
							System.out.println("_Ziel gefunden_");
						}
						r.add(g);
						System.out.println("Neighbour:" + g.getRow() + " "
								+ g.getColumn());
					}
				}
			}
		}
		return r;
	}

	/**
	 * Unterteil der Methode findNeighbours
	 * 
	 * @author jzimdars
	 */
	private boolean checkClosedList(Gangfeld g, Vector<Gangfeld> closedList) {
		boolean r = true;
		for (Gangfeld c : closedList) {
			if (c.equals(g)) {
				r = false;
				System.out.println(g.getRow() + " " + g.getColumn()
						+ "is in closedList");
			}
		}
		return r;
	}

	/**
	 * Unterteil der Methode findNeighbours
	 * 
	 * @author jzimdars
	 */
	private boolean checkWalls(Gangfeld a, Gangfeld g) {
		// ways[0] = north;
		// ways[1] = east;
		// ways[2] = south;
		// ways[3] = west;
		boolean r = false;
		// g im norden
		if (a.getColumn() == g.getColumn() + 1) {
			boolean[] aWays = a.getWays();
			boolean[] gWays = g.getWays();
			if (aWays[0] && gWays[2]) {
				r = true;
			}
		}
		// g im osten
		if (a.getRow() == g.getRow() - 1) {
			boolean[] aWays = a.getWays();
			boolean[] gWays = g.getWays();
			if (aWays[1] && gWays[3]) {
				r = true;
			}
		}
		// g im sden
		if (a.getColumn() == g.getColumn() - 1) {
			boolean[] aWays = a.getWays();
			boolean[] gWays = g.getWays();
			if (aWays[2] && gWays[0]) {
				r = true;
			}
		}
		// g im westen
		if (a.getRow() == g.getRow() + 1) {
			boolean[] aWays = a.getWays();
			boolean[] gWays = g.getWays();
			if (aWays[3] && gWays[1]) {
				r = true;
			}
		}
		return r;
	}
}