<?php
session_start();
?>
<html>
<head>
	<title>Welcome the Hitchhiker's Guide</title>
	<LINK REL=StyleSheet HREF="style.css" TYPE="text/css"/>
</head>

<body onload="showSignup()">
<div id="container">

<!-- Main Text containing information on the concept of the website and other details -->
<p>
Hitchhiker is a new concept for Australians aiming to connect drivers who would like some company and petrol money, with people who need to take a trip but don't have access to a car. It is cheaper than taking a taxi, faster than public transport, and with a bit of luck you could make a new friend.</p>

<p>Signing up is easy - we just need a few basic details from you and you can start searching for a ride. Verification options are provided for drivers so hitchers can be sure their trip will be safe.</p>

<?php if (!isset($_SESSION["member"])) { ?>
<p><a href="#" onClick="showSignup()">Sign Up</a> now and try it out! or <a href="#" onClick="showLogin()">login</a></p>
<div id="signuplogin">
<?php
include("login.php");
include("signup.php");
?>
</div>
</div>
</body>
</html>

<?php }
else echo "Proceed to <a href=\"memberhome.php\">Members Area</a>";
?>
<script src="validateemailscript.js" type="text/javascript"></script>
<script src="trimscript.js" type="text/javascript"></script>
<script type="text/javascript">
var validusername=false;
var errortext="";

function showSignup() {
	document.getElementById("login").style.visibility = "hidden";
	document.getElementById("signup").style.visibility = "visible";
}

function showLogin() {
	document.getElementById("login").style.visibility = "visible";
	document.getElementById("signup").style.visibility = "hidden";
}

function validateFields() {
	//If there is a blank field, this becomes true
	var showAlertMissingFields=false;
	//If password fields match, this becomes true
	var passwordsMatch=false;
	//If the email is successfully validated against the regular expression, this becomes true
	var validEmail=false;

	document.signup.username.value=trimAll(document.signup.username.value);
	document.signup.email.value=trimAll(document.signup.email.value);
	document.signup.firstname.value=trimAll(document.signup.firstname.value);
	document.signup.surname.value=trimAll(document.signup.surname.value);
	
	//Individually checks each field to make sure it is not blank before the form is submitted
	if (document.signup.username.value=="") {
		showAlertMissingFields=true;
	}
	else if (document.signup.password.value=="") {
		showAlertMissingFields=true;
	}
	else if (document.signup.confirmPassword.value=="") {
		showAlertMissingFields=true;
	}
	else if (document.signup.email.value=="") {
		showAlertMissingFields=true;
	}
	else if (document.signup.firstname.value=="") {
		showAlertMissingFields=true;
	}
	else if (document.signup.surname.value=="") {
		showAlertMissingFields=true;
	}

	if (showAlertMissingFields) {
		errortext = errortext + "\n   Some required fields are missing";
	}

	//Check that the password and confirm password fields are the same
	if (document.signup.password.value!=document.signup.confirmPassword.value) {
		passwordsMatch=false;
	}
	else {
		passwordsMatch=true;
	}
	if (!passwordsMatch) {
		errortext = errortext + "\n   Password does not match confirmed password";
	}

	//Check the email is valid
	if (!validateEmail(document.signup.email.value)) {
		errortext = errortext + "\n   Please enter a valid email address";
	}
	else {
		validEmail=true;
	}

	if (validusername==false) {
		errortext = errortext + "\n   This username is already in use";
	}

	if (errortext != "") {
		alert ("Please address the following errors:" + errortext);
		errortext = "";
	}

	//Submit form if all fields contain values and the passwords match and the username is available
	if (passwordsMatch) {
		if (!showAlertMissingFields) {
			if (validEmail) {
				if (validusername) {
					document.signup.submit();
				}
			}
		}
	}
}


function checkValidUsername()
{
var xmlhttp;
if (window.XMLHttpRequest)
  {
  // code for IE7+, Firefox, Chrome, Opera, Safari
  xmlhttp=new XMLHttpRequest();
  }
else
  {
  // code for IE6, IE5
  xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
xmlhttp.onreadystatechange=function()
{
if(xmlhttp.readyState==4)
  {
	if (xmlhttp.responseText=="available") {
	  document.getElementById("validusername").innerHTML="valid username";
		validusername=true;
	}
	else {
		document.getElementById("validusername").innerHTML="username in use";
		validusername=false;
	}
  }
}
xmlhttp.open("GET","checkusername.php?user="+document.signup.username.value,true);
xmlhttp.send(null);
}
</script>